/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.rules;

import java.util.HashMap;
import java.util.Map;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ApplicationContext;
import org.milyn.rules.RuleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleProviderAccessor {
    private RuleProviderAccessor() {
    }

    public static final void add(ApplicationContext context, RuleProvider provider) {
        AssertArgument.isNotNull((Object)context, (String)"context");
        AssertArgument.isNotNull((Object)provider, (String)"provider");
        Map<String, RuleProvider> providers = RuleProviderAccessor.getRuleProviders(context);
        if (providers == null) {
            providers = new HashMap<String, RuleProvider>();
            context.setAttribute(RuleProvider.class, providers);
        }
        providers.put(provider.getName(), provider);
    }

    public static final RuleProvider get(ApplicationContext context, String ruleProviderName) {
        AssertArgument.isNotNull((Object)context, (String)"context");
        Map<String, RuleProvider> providers = RuleProviderAccessor.getRuleProviders(context);
        if (providers == null || providers.isEmpty()) {
            throw new SmooksException("No RuleProviders were found. Have you configured a rules section in your Smooks configuration?");
        }
        RuleProvider provider = providers.get(ruleProviderName);
        if (provider == null) {
            throw new SmooksException("Not provider with name '" + ruleProviderName + "' was found in the execution context. Have you configured the rules section properly?");
        }
        return provider;
    }

    public static Map<String, RuleProvider> getRuleProviders(ApplicationContext context) {
        return (Map)context.getAttribute(RuleProvider.class);
    }

    public static String parseRuleName(String compositeRuleName) {
        int lastIndexOfDot = compositeRuleName.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            RuleProviderAccessor.throwInvalidCompositeRuleName(compositeRuleName);
        }
        return compositeRuleName.substring(lastIndexOfDot + 1);
    }

    public static String parseRuleProviderName(String compositeRuleName) {
        int lastIndexOfDot = compositeRuleName.indexOf(46);
        if (lastIndexOfDot == -1) {
            RuleProviderAccessor.throwInvalidCompositeRuleName(compositeRuleName);
        }
        return compositeRuleName.substring(0, lastIndexOfDot);
    }

    private static void throwInvalidCompositeRuleName(String compositRuleName) {
        throw new SmooksException("A rule must be specified in the format <ruleProviderName>.<ruleName>. Please check you configuration and make sure that you are referencing the rule in a correct manner.");
    }
}

