/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.mockftpserver.core.MockFtpServerException;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.session.DefaultSession;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.socket.DefaultServerSocketFactory;
import org.mockftpserver.core.socket.ServerSocketFactory;
import org.mockftpserver.core.util.Assert;

public abstract class AbstractFtpServer
implements Runnable {
    public static final String REPLY_TEXT_BASENAME = "ReplyText";
    private static final int DEFAULT_SERVER_CONTROL_PORT = 21;
    protected Logger LOG = Logger.getLogger(this.getClass());
    protected ServerSocketFactory serverSocketFactory = new DefaultServerSocketFactory();
    private ServerSocket serverSocket = null;
    private ResourceBundle replyTextBundle;
    private volatile boolean terminate = false;
    private Map commandHandlers;
    private Thread serverThread;
    private int serverControlPort = 21;
    private final Object startLock = new Object();
    private Map sessions = new HashMap();

    public AbstractFtpServer() {
        this.replyTextBundle = ResourceBundle.getBundle(REPLY_TEXT_BASENAME);
        this.commandHandlers = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.serverThread = new Thread(this);
        Object object = this.startLock;
        synchronized (object) {
            try {
                this.serverThread.start();
                this.startLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new MockFtpServerException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.LOG.info((Object)("Starting the server on port " + this.serverControlPort));
            this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverControlPort);
            Object object = this.startLock;
            synchronized (object) {
                this.startLock.notify();
            }
            this.serverSocket.setSoTimeout(500);
            while (!this.terminate) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    this.LOG.info((Object)("Connection accepted from host " + clientSocket.getInetAddress()));
                    Session session = this.createSession(clientSocket);
                    Thread sessionThread = new Thread(session);
                    sessionThread.start();
                    SessionInfo sessionInfo = new SessionInfo();
                    sessionInfo.socket = clientSocket;
                    sessionInfo.thread = sessionThread;
                    this.sessions.put(session, sessionInfo);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.LOG.trace((Object)"Socket accept() timeout");
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error", (Throwable)e);
        }
        finally {
            this.LOG.debug((Object)"Cleaning up server...");
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
                this.closeSessions();
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error cleaning up server", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.LOG.error((Object)"Error cleaning up server", (Throwable)e);
            }
            this.LOG.info((Object)"Server stopped.");
            this.terminate = false;
        }
    }

    public void stop() {
        this.LOG.trace((Object)"Stopping the server...");
        this.terminate = true;
        try {
            if (this.serverThread != null) {
                this.serverThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new MockFtpServerException(e);
        }
    }

    public CommandHandler getCommandHandler(String name) {
        return (CommandHandler)this.commandHandlers.get(Command.normalizeName(name));
    }

    public void setCommandHandlers(Map commandHandlerMapping) {
        Assert.notNull(commandHandlerMapping, "commandHandlers");
        Iterator iter = commandHandlerMapping.keySet().iterator();
        while (iter.hasNext()) {
            String commandName = (String)iter.next();
            this.setCommandHandler(commandName, (CommandHandler)commandHandlerMapping.get(commandName));
        }
    }

    public void setCommandHandler(String commandName, CommandHandler commandHandler) {
        Assert.notNull(commandName, "commandName");
        Assert.notNull(commandHandler, "commandHandler");
        this.commandHandlers.put(Command.normalizeName(commandName), commandHandler);
        this.initializeCommandHandler(commandHandler);
    }

    public void setReplyTextBaseName(String baseName) {
        this.replyTextBundle = ResourceBundle.getBundle(baseName);
    }

    public ResourceBundle getReplyTextBundle() {
        return this.replyTextBundle;
    }

    public void setServerControlPort(int serverControlPort) {
        this.serverControlPort = serverControlPort;
    }

    public boolean isShutdown() {
        boolean shutdown = !this.serverThread.isAlive() && this.serverSocket.isClosed();
        Iterator iter = this.sessions.values().iterator();
        while (iter.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)iter.next();
            shutdown = shutdown && sessionInfo.socket.isClosed() && !sessionInfo.thread.isAlive();
        }
        return shutdown;
    }

    public boolean isStarted() {
        return this.serverThread != null && this.serverThread.isAlive() && this.serverSocket != null;
    }

    protected Session createSession(Socket clientSocket) {
        return new DefaultSession(clientSocket, this.commandHandlers);
    }

    private void closeSessions() throws InterruptedException, IOException {
        Iterator iter = this.sessions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Session session = (Session)entry.getKey();
            SessionInfo sessionInfo = (SessionInfo)entry.getValue();
            session.close();
            sessionInfo.thread.join(500L);
            Socket sessionSocket = sessionInfo.socket;
            if (sessionSocket == null) continue;
            sessionSocket.close();
        }
    }

    protected abstract void initializeCommandHandler(CommandHandler var1);

    private static class SessionInfo {
        Socket socket;
        Thread thread;

        private SessionInfo() {
        }
    }
}

