/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.IoUtil;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemException;

public class RetrCommandHandler
extends AbstractFakeCommandHandler {
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        this.replyCodeForFileSystemException = 550;
        String path = this.getRealPath(session, command.getRequiredParameter(0));
        FileSystemEntry entry = this.getFileSystem().getEntry(path);
        this.verifyFileSystemCondition(entry != null, path, "filesystem.doesNotExist");
        this.verifyFileSystemCondition(!entry.isDirectory(), path, "filesystem.isNotAFile");
        FileEntry fileEntry = (FileEntry)entry;
        this.verifyReadPermission(session, path);
        this.verifyExecutePermission(session, this.getFileSystem().getParent(path));
        this.sendReply(session, 150);
        InputStream input = fileEntry.createInputStream();
        session.openDataConnection();
        byte[] bytes = null;
        try {
            bytes = IoUtil.readBytes(input);
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error reading from file [" + fileEntry.getPath() + "]"), (Throwable)e);
            throw new FileSystemException(fileEntry.getPath(), null, e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.LOG.error((Object)("Error closing InputStream for file [" + fileEntry.getPath() + "]"), (Throwable)e);
            }
        }
        if (this.isAsciiMode(session)) {
            bytes = this.convertLfToCrLf(bytes);
        }
        session.sendData(bytes, bytes.length);
        session.closeDataConnection();
        this.sendReply(session, 226);
    }

    protected byte[] convertLfToCrLf(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int lastChar = 32;
        for (int i = 0; i < bytes.length; ++i) {
            char ch = (char)bytes[i];
            if (ch == '\n' && lastChar != 13) {
                out.write(13);
                out.write(10);
            } else {
                out.write(bytes[i]);
            }
            lastChar = ch;
        }
        return out.toByteArray();
    }

    private boolean isAsciiMode(Session session) {
        return session.getAttribute("asciiType") != Boolean.FALSE;
    }
}

