/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.ResponseBuffers;
import org.bson.io.OutputBuffer;

class SendMessageCallback<T>
implements SingleResultCallback<Void> {
    private final OutputBuffer buffer;
    private final InternalConnection connection;
    private final SingleResultCallback<ResponseBuffers> receiveMessageCallback;
    private final int requestId;
    private final SingleResultCallback<T> callback;

    SendMessageCallback(InternalConnection connection, OutputBuffer buffer, int requestId, SingleResultCallback<T> callback, SingleResultCallback<ResponseBuffers> receiveMessageCallback) {
        this.buffer = buffer;
        this.connection = connection;
        this.callback = callback;
        this.receiveMessageCallback = receiveMessageCallback;
        this.requestId = requestId;
    }

    @Override
    public void onResult(Void result, Throwable t) {
        this.buffer.close();
        if (t != null) {
            this.callback.onResult(null, t);
        } else {
            this.connection.receiveMessageAsync(this.requestId, this.receiveMessageCallback);
        }
    }
}

