/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.hadoop.input.GridFSSplit;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.types.ObjectId;

public class GridFSInputFormat
extends InputFormat<NullWritable, BinaryComparable> {
    private static final Log LOG = LogFactory.getLog(GridFSInputFormat.class);

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBCollection inputCollection = MongoConfigUtil.getInputCollection(conf);
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(conf);
        GridFS gridFS = new GridFS(inputCollection.getDB(), inputCollection.getName());
        DBObject query = MongoConfigUtil.getQuery(conf);
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        for (GridFSDBFile file : gridFS.find(query)) {
            if (MongoConfigUtil.isGridFSWholeFileSplit(conf)) {
                splits.add(new GridFSSplit(inputURI, (ObjectId)file.getId(), (int)file.getChunkSize(), file.getLength()));
                continue;
            }
            for (int chunk = 0; chunk < file.numChunks(); ++chunk) {
                splits.add(new GridFSSplit(inputURI, (ObjectId)file.getId(), (int)file.getChunkSize(), file.getLength(), chunk));
            }
        }
        LOG.debug((Object)("Found GridFS splits: " + splits));
        return splits;
    }

    public RecordReader<NullWritable, BinaryComparable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (MongoConfigUtil.isGridFSReadBinary(context.getConfiguration())) {
            return new GridFSBinaryRecordReader();
        }
        return new GridFSTextRecordReader();
    }

    static class GridFSTextRecordReader
    extends RecordReader<NullWritable, BinaryComparable> {
        private GridFSSplit split;
        private final Text text = new Text();
        private int totalMatches = 0;
        private long chunkSize;
        private boolean readLast;
        private boolean readWholeFile;
        private Pattern delimiterPattern;
        private Matcher matcher;
        private int previousMatchIndex = 0;
        private ChunkReadingCharSequence chunkData;

        GridFSTextRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.split = (GridFSSplit)split;
            Configuration conf = context.getConfiguration();
            String patternString = MongoConfigUtil.getGridFSDelimiterPattern(conf);
            this.chunkSize = this.split.getChunkSize();
            this.chunkData = new ChunkReadingCharSequence(this.split);
            this.readLast = false;
            this.readWholeFile = MongoConfigUtil.isGridFSWholeFileSplit(conf);
            if (null != patternString && !patternString.isEmpty()) {
                this.delimiterPattern = Pattern.compile(patternString);
                this.matcher = this.delimiterPattern.matcher(this.chunkData);
                if (this.split.getChunkId() > 0) {
                    this.nextToken();
                }
            }
        }

        private CharSequence nextToken() {
            if (this.matcher.find()) {
                CharSequence slice = this.chunkData.subSequence(this.previousMatchIndex, this.matcher.start());
                this.previousMatchIndex = this.matcher.end();
                return slice;
            }
            this.readLast = true;
            return this.chunkData.subSequence(this.previousMatchIndex, this.chunkData.length());
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.readLast) {
                LOG.debug((Object)("skipping the rest of this chunk because we've read beyond the end: " + this.previousMatchIndex + "; read " + this.totalMatches + " matches here."));
                return false;
            }
            if (null == this.matcher) {
                if (this.readWholeFile) {
                    this.text.set(this.chunkData.fileContents().toString());
                } else {
                    this.text.set(this.chunkData.chunkContents().toString());
                }
                ++this.totalMatches;
                this.readLast = true;
                return true;
            }
            CharSequence nextToken = this.nextToken();
            if (nextToken != null) {
                if (!this.readWholeFile && (long)this.previousMatchIndex >= this.chunkSize) {
                    this.readLast = true;
                }
                this.text.set(nextToken.toString());
                ++this.totalMatches;
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Read " + this.totalMatches + " segments."));
            }
            return false;
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.text;
        }

        public float getProgress() throws IOException, InterruptedException {
            return (float)Math.min((double)((float)this.previousMatchIndex / (float)this.chunkSize), 1.0);
        }

        public void close() throws IOException {
            this.chunkData.close();
        }
    }

    static class ChunkReadingCharSequence
    implements CharSequence,
    Closeable {
        private Reader reader;
        private int chunkSize;
        private int length;
        private StringBuilder builder;
        private char[] buff;

        public ChunkReadingCharSequence(GridFSSplit split) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(split.getData()));
            this.chunkSize = split.getChunkSize();
            this.builder = new StringBuilder();
            this.buff = new char[0x1000000];
            this.length = (int)split.getLength() - split.getChunkId() * this.chunkSize;
        }

        @Override
        public int length() {
            return this.length;
        }

        private void advanceToIndex(int index) throws IOException {
            if (index >= this.builder.length()) {
                int bytesRead;
                while (index >= this.builder.length() && (bytesRead = this.reader.read(this.buff)) > 0) {
                    this.builder.append(this.buff, 0, bytesRead);
                }
            }
        }

        @Override
        public char charAt(int index) {
            try {
                this.advanceToIndex(index);
            }
            catch (IOException e) {
                throw new IndexOutOfBoundsException("Could not advance stream to index: " + index + "; reason: " + e.getMessage());
            }
            return this.builder.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            try {
                this.advanceToIndex(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.builder.subSequence(start, end);
        }

        public CharSequence chunkContents() {
            return this.subSequence(0, Math.min(this.chunkSize, this.length));
        }

        public CharSequence fileContents() {
            return this.subSequence(0, this.length);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    static class GridFSBinaryRecordReader
    extends RecordReader<NullWritable, BinaryComparable> {
        private final BytesWritable bw = new BytesWritable();
        private GridFSSplit split;
        private InputStream stream;
        private boolean readLast;
        private byte[] buff;

        GridFSBinaryRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.split = (GridFSSplit)split;
            this.readLast = false;
            this.buff = new byte[0x1000000];
            this.stream = this.split.getData();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            int bytesRead;
            if (this.readLast) {
                return false;
            }
            int totalBytes = 0;
            do {
                if ((bytesRead = this.stream.read(this.buff, totalBytes, this.buff.length - totalBytes)) <= 0) continue;
                totalBytes += bytesRead;
            } while (bytesRead > 0);
            this.bw.set(this.buff, 0, totalBytes);
            this.readLast = true;
            return true;
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public BytesWritable getCurrentValue() throws IOException, InterruptedException {
            return this.bw;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.readLast ? 1.0f : 0.0f;
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

