/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;

public class MongoConfig {
    private static final Log LOG = LogFactory.getLog(MongoConfig.class);
    private final Configuration configuration;

    @Deprecated
    public MongoConfig() {
        this.configuration = new Configuration();
    }

    public MongoConfig(Configuration conf) {
        this.configuration = conf;
    }

    public MongoConfig(DataInput in) throws IOException {
        this.configuration = new Configuration();
        this.configuration.readFields(in);
    }

    public boolean isJobVerbose() {
        return MongoConfigUtil.isJobVerbose(this.configuration);
    }

    public void setJobVerbose(boolean val) {
        MongoConfigUtil.setJobVerbose(this.configuration, val);
    }

    public boolean isJobBackground() {
        return MongoConfigUtil.isJobBackground(this.configuration);
    }

    public void setJobBackground(boolean val) {
        MongoConfigUtil.setJobBackground(this.configuration, val);
    }

    public Class<? extends Mapper> getMapper() {
        return MongoConfigUtil.getMapper(this.configuration);
    }

    public void setMapper(Class<? extends Mapper> val) {
        MongoConfigUtil.setMapper(this.configuration, val);
    }

    public Class<?> getMapperOutputKey() {
        return MongoConfigUtil.getMapperOutputKey(this.configuration);
    }

    public void setMapperOutputKey(Class<?> val) {
        MongoConfigUtil.setMapperOutputKey(this.configuration, val);
    }

    public Class<?> getMapperOutputValue() {
        return MongoConfigUtil.getMapperOutputValue(this.configuration);
    }

    public void setMapperOutputValue(Class<?> val) {
        MongoConfigUtil.setMapperOutputValue(this.configuration, val);
    }

    public Class<? extends Reducer> getCombiner() {
        return MongoConfigUtil.getCombiner(this.configuration);
    }

    public void setCombiner(Class<? extends Reducer> val) {
        MongoConfigUtil.setCombiner(this.configuration, val);
    }

    public Class<? extends Reducer> getReducer() {
        return MongoConfigUtil.getReducer(this.configuration);
    }

    public void setReducer(Class<? extends Reducer> val) {
        MongoConfigUtil.setReducer(this.configuration, val);
    }

    public Class<? extends Partitioner> getPartitioner() {
        return MongoConfigUtil.getPartitioner(this.configuration);
    }

    public void setPartitioner(Class<? extends Partitioner> val) {
        MongoConfigUtil.setPartitioner(this.configuration, val);
    }

    public Class<? extends RawComparator> getSortComparator() {
        return MongoConfigUtil.getSortComparator(this.configuration);
    }

    public void setSortComparator(Class<? extends RawComparator> val) {
        MongoConfigUtil.setSortComparator(this.configuration, val);
    }

    public Class<? extends OutputFormat> getOutputFormat() {
        return MongoConfigUtil.getOutputFormat(this.configuration);
    }

    public void setOutputFormat(Class<? extends OutputFormat> val) {
        MongoConfigUtil.setOutputFormat(this.configuration, val);
    }

    public Class<?> getOutputKey() {
        return MongoConfigUtil.getOutputKey(this.configuration);
    }

    public void setOutputKey(Class<?> val) {
        MongoConfigUtil.setOutputKey(this.configuration, val);
    }

    public Class<?> getOutputValue() {
        return MongoConfigUtil.getOutputValue(this.configuration);
    }

    public void setOutputValue(Class<?> val) {
        MongoConfigUtil.setOutputValue(this.configuration, val);
    }

    public Class<? extends InputFormat> getInputFormat() {
        return MongoConfigUtil.getInputFormat(this.configuration);
    }

    public void setInputFormat(Class<? extends InputFormat> val) {
        MongoConfigUtil.setInputFormat(this.configuration, val);
    }

    public MongoClientURI getMongoURI(String key) {
        return MongoConfigUtil.getMongoClientURI(this.configuration, key);
    }

    public MongoClientURI getInputURI() {
        return MongoConfigUtil.getInputURI(this.configuration);
    }

    public MongoClientURI getAuthURI() {
        return MongoConfigUtil.getAuthURI(this.configuration);
    }

    public DBCollection getOutputCollection() {
        return MongoConfigUtil.getOutputCollection(this.configuration);
    }

    public DBCollection getInputCollection() {
        return MongoConfigUtil.getInputCollection(this.configuration);
    }

    public void setMongoURI(String key, MongoURI value) {
        this.setMongoURI(key, new MongoClientURI(value.toString()));
    }

    public void setMongoURI(String key, MongoClientURI value) {
        MongoConfigUtil.setMongoURI(this.configuration, key, value);
    }

    public void setMongoURIString(String key, String value) {
        MongoConfigUtil.setMongoURIString(this.configuration, key, value);
    }

    public void setInputURI(String uri) {
        MongoConfigUtil.setInputURI(this.configuration, uri);
    }

    @Deprecated
    public void setInputURI(MongoURI uri) {
        MongoConfigUtil.setInputURI(this.configuration, uri);
    }

    public void setInputURI(MongoClientURI uri) {
        MongoConfigUtil.setInputURI(this.configuration, uri);
    }

    public void setAuthUri(String uri) {
        MongoConfigUtil.setAuthURI(this.configuration, uri);
    }

    public MongoClientURI getOutputURI() {
        return MongoConfigUtil.getOutputURI(this.configuration);
    }

    public void setOutputURI(String uri) {
        MongoConfigUtil.setOutputURI(this.configuration, uri);
    }

    @Deprecated
    public void setOutputURI(MongoURI uri) {
        MongoConfigUtil.setOutputURI(this.configuration, uri);
    }

    public void setOutputURI(MongoClientURI uri) {
        MongoConfigUtil.setOutputURI(this.configuration, uri);
    }

    public void setJSON(String key, String value) {
        MongoConfigUtil.setJSON(this.configuration, key, value);
    }

    public DBObject getDBObject(String key) {
        return MongoConfigUtil.getDBObject(this.configuration, key);
    }

    public void setDBObject(String key, DBObject value) {
        MongoConfigUtil.setDBObject(this.configuration, key, value);
    }

    public void setQuery(String query) {
        MongoConfigUtil.setQuery(this.configuration, query);
    }

    public void setQuery(DBObject query) {
        MongoConfigUtil.setQuery(this.configuration, query);
    }

    public DBObject getQuery() {
        return MongoConfigUtil.getQuery(this.configuration);
    }

    public void setFields(String fields) {
        MongoConfigUtil.setFields(this.configuration, fields);
    }

    public void setFields(DBObject fields) {
        MongoConfigUtil.setFields(this.configuration, fields);
    }

    public DBObject getFields() {
        return MongoConfigUtil.getFields(this.configuration);
    }

    public void setSort(String sort) {
        MongoConfigUtil.setSort(this.configuration, sort);
    }

    public void setSort(DBObject sort) {
        MongoConfigUtil.setSort(this.configuration, sort);
    }

    public DBObject getSort() {
        return MongoConfigUtil.getSort(this.configuration);
    }

    public int getLimit() {
        return MongoConfigUtil.getLimit(this.configuration);
    }

    public void setLimit(int limit) {
        MongoConfigUtil.setLimit(this.configuration, limit);
    }

    public int getSkip() {
        return MongoConfigUtil.getSkip(this.configuration);
    }

    public void setSkip(int skip) {
        MongoConfigUtil.setSkip(this.configuration, skip);
    }

    public boolean getLazyBSON() {
        return MongoConfigUtil.getLazyBSON(this.configuration);
    }

    public void setLazyBSON(boolean lazy) {
        MongoConfigUtil.setLazyBSON(this.configuration, lazy);
    }

    public int getSplitSize() {
        return MongoConfigUtil.getSplitSize(this.configuration);
    }

    public void setSplitSize(int value) {
        MongoConfigUtil.setSplitSize(this.configuration, value);
    }

    public boolean canReadSplitsFromShards() {
        return MongoConfigUtil.canReadSplitsFromShards(this.configuration);
    }

    public void setReadSplitsFromShards(boolean value) {
        MongoConfigUtil.setReadSplitsFromShards(this.configuration, value);
    }

    public boolean isShardChunkedSplittingEnabled() {
        return MongoConfigUtil.isShardChunkedSplittingEnabled(this.configuration);
    }

    public void setShardChunkSplittingEnabled(boolean value) {
        MongoConfigUtil.setShardChunkSplittingEnabled(this.configuration, value);
    }

    public boolean isRangeQueryEnabled() {
        return MongoConfigUtil.isRangeQueryEnabled(this.configuration);
    }

    public void setRangeQueryEnabled(boolean value) {
        MongoConfigUtil.setRangeQueryEnabled(this.configuration, value);
    }

    public boolean canReadSplitsFromSecondary() {
        return MongoConfigUtil.canReadSplitsFromSecondary(this.configuration);
    }

    public void setReadSplitsFromSecondary(boolean value) {
        MongoConfigUtil.setReadSplitsFromSecondary(this.configuration, value);
    }

    public String getInputSplitKeyPattern() {
        return MongoConfigUtil.getInputSplitKeyPattern(this.configuration);
    }

    public DBObject getInputSplitKey() {
        return MongoConfigUtil.getInputSplitKey(this.configuration);
    }

    public void setInputSplitKeyPattern(String pattern) {
        MongoConfigUtil.setInputSplitKeyPattern(this.configuration, pattern);
    }

    public void setInputSplitKey(DBObject key) {
        MongoConfigUtil.setInputSplitKey(this.configuration, key);
    }

    public boolean createInputSplits() {
        return MongoConfigUtil.createInputSplits(this.configuration);
    }

    public void setCreateInputSplits(boolean value) {
        MongoConfigUtil.setCreateInputSplits(this.configuration, value);
    }

    public String getInputKey() {
        return MongoConfigUtil.getInputKey(this.configuration);
    }

    public void setInputKey(String fieldName) {
        MongoConfigUtil.setInputKey(this.configuration, fieldName);
    }

    public boolean isNoTimeout() {
        return MongoConfigUtil.isNoTimeout(this.configuration);
    }

    public void setNoTimeout(boolean value) {
        MongoConfigUtil.setNoTimeout(this.configuration, value);
    }

    public boolean getBSONReadSplits() {
        return MongoConfigUtil.getBSONReadSplits(this.configuration);
    }

    public void setBSONReadSplits(boolean val) {
        MongoConfigUtil.setBSONReadSplits(this.configuration, val);
    }

    public boolean getBSONWriteSplits() {
        return MongoConfigUtil.getBSONWriteSplits(this.configuration);
    }

    public void setBSONWriteSplits(boolean val) {
        MongoConfigUtil.setBSONWriteSplits(this.configuration, val);
    }

    public boolean getBSONOutputBuildSplits() {
        return MongoConfigUtil.getBSONOutputBuildSplits(this.configuration);
    }

    public void setBSONOutputBuildSplits(boolean val) {
        MongoConfigUtil.setBSONOutputBuildSplits(this.configuration, val);
    }

    public void setBSONPathFilter(Class<? extends PathFilter> val) {
        MongoConfigUtil.setBSONPathFilter(this.configuration, val);
    }

    public Class<?> getBSONPathFilter() {
        return MongoConfigUtil.getBSONPathFilter(this.configuration);
    }
}

