/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.input.MongoRecordReader;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.splitter.MongoSplitterFactory;
import com.mongodb.hadoop.splitter.SplitFailedException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoInputFormat
extends InputFormat<Object, BSONObject> {
    private static final Log LOG = LogFactory.getLog(MongoInputFormat.class);

    public RecordReader<Object, BSONObject> createRecordReader(InputSplit split, TaskAttemptContext context) {
        if (!(split instanceof MongoInputSplit)) {
            throw new IllegalStateException("Creation of a new RecordReader requires a MongoInputSplit instance.");
        }
        MongoInputSplit mis = (MongoInputSplit)split;
        return new MongoRecordReader(mis);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        try {
            MongoSplitter splitterImpl = MongoSplitterFactory.getSplitter(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using " + splitterImpl.toString() + " to calculate splits."));
            }
            return splitterImpl.calculateSplits();
        }
        catch (SplitFailedException spfe) {
            throw new IOException(spfe);
        }
    }

    public boolean verifyConfiguration(Configuration conf) {
        return true;
    }
}

