/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.output.MongoOutputCommitter;
import com.mongodb.hadoop.output.MongoRecordWriter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MongoOutputFormat<K, V>
extends OutputFormat<K, V> {
    public void checkOutputSpecs(JobContext context) throws IOException {
        if (MongoConfigUtil.getOutputURIs(context.getConfiguration()).isEmpty()) {
            throw new IOException("No output URI is specified. You must set mongo.output.uri.");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new MongoOutputCommitter();
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) {
        return new MongoRecordWriter(MongoConfigUtil.getOutputCollection(context.getConfiguration()), context);
    }

    public MongoOutputFormat() {
    }

    @Deprecated
    public MongoOutputFormat(String[] updateKeys, boolean multiUpdate) {
        this();
    }
}

