/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.hadoop.input.BSONFileSplit;
import com.mongodb.hadoop.util.MongoConfigUtil;
import com.mongodb.hadoop.util.MongoPathRetriever;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;

public class BSONFileRecordReader
extends RecordReader<Object, BSONObject> {
    private static final Log LOG = LogFactory.getLog(BSONFileRecordReader.class);
    private FileSplit fileSplit;
    private BSONObject value;
    private FSDataInputStream inRaw;
    private InputStream in;
    private int numDocsRead = 0;
    private boolean finished = false;
    private long startingPosition;
    private BSONCallback callback;
    private BSONDecoder decoder;
    private Configuration configuration;
    private Decompressor decompressor;

    public BSONFileRecordReader() {
        this(-1L);
    }

    public BSONFileRecordReader(long startingPosition) {
        this.startingPosition = startingPosition;
    }

    public void init(InputSplit inputSplit, Configuration configuration) throws IOException, InterruptedException {
        this.configuration = configuration;
        this.fileSplit = (FileSplit)inputSplit;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading split " + this.fileSplit));
        }
        Path file = this.fileSplit.getPath();
        FileSystem fs = file.getFileSystem(configuration);
        CompressionCodec codec = new CompressionCodecFactory(configuration).getCodec(this.fileSplit.getPath());
        this.inRaw = fs.open(file, 0x1000000);
        this.inRaw.seek(this.startingPosition == -1L ? this.fileSplit.getStart() : this.startingPosition);
        if (codec != null) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            this.in = codec.createInputStream((InputStream)this.inRaw, this.decompressor);
        } else {
            this.in = this.inRaw;
        }
        if (MongoConfigUtil.getLazyBSON(configuration)) {
            this.callback = new LazyBSONCallback();
            this.decoder = new LazyBSONDecoder();
        } else {
            this.callback = new BasicBSONCallback();
            this.decoder = new BasicBSONDecoder();
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.init(inputSplit, context.getConfiguration());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            long pos;
            if (null == this.decompressor && (pos = ((Seekable)this.in).getPos()) >= this.fileSplit.getStart() + this.fileSplit.getLength()) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
            this.callback.reset();
            try {
                this.decoder.decode(this.in, this.callback);
            }
            catch (EOFException e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e2);
                }
                return false;
            }
            this.value = (BSONObject)this.callback.get();
            ++this.numDocsRead;
            if (this.numDocsRead % 10000 == 0 && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("read %d docs from %s at %d", this.numDocsRead, this.fileSplit, this.inRaw.getPos()));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error reading key/value from bson file on line %d: %s", this.numDocsRead, e.getMessage()), (Throwable)e);
            try {
                this.close();
            }
            catch (Exception e2) {
                LOG.warn((Object)e2.getMessage(), (Throwable)e2);
            }
            return false;
        }
    }

    public Object getCurrentKey() throws IOException, InterruptedException {
        Object key = null;
        if (this.fileSplit instanceof BSONFileSplit) {
            key = MongoPathRetriever.get(this.value, ((BSONFileSplit)this.fileSplit).getKeyField());
        }
        return key != null ? key : NullWritable.get();
    }

    public BSONObject getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.finished) {
            return 1.0f;
        }
        if (this.inRaw != null) {
            return (float)(this.inRaw.getPos() - this.fileSplit.getStart()) / (float)this.fileSplit.getLength();
        }
        return 0.0f;
    }

    public void close() throws IOException {
        this.finished = true;
        if (this.inRaw != null) {
            this.inRaw.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.decompressor != null) {
            CodecPool.returnDecompressor((Decompressor)this.decompressor);
        }
    }
}

