/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.types.ObjectId;

public class GridFSSplit
extends InputSplit
implements org.apache.hadoop.mapred.InputSplit {
    private ObjectId fileId;
    private int chunkSize;
    private long fileLength;
    private int chunkId;
    private MongoClientURI inputURI;
    private GridFS gridFS;
    private GridFSDBFile file;

    public GridFSSplit() {
    }

    public GridFSSplit(MongoClientURI inputURI, ObjectId fileId, int chunkSize, long fileLength) {
        this(inputURI, fileId, chunkSize, fileLength, 0);
    }

    public GridFSSplit(MongoClientURI inputURI, ObjectId fileId, int chunkSize, long fileLength, int chunkId) {
        this.inputURI = inputURI;
        this.fileId = fileId;
        this.chunkSize = chunkSize;
        this.fileLength = fileLength;
        this.chunkId = chunkId;
    }

    private GridFS getGridFS() {
        if (null == this.gridFS) {
            DBCollection rootCollection = MongoConfigUtil.getCollection(this.inputURI);
            this.gridFS = new GridFS(rootCollection.getDB(), rootCollection.getName());
        }
        return this.gridFS;
    }

    private GridFSDBFile getFile() throws IOException {
        if (null == this.file) {
            this.file = this.getGridFS().find(this.fileId);
            if (null == this.file) {
                throw new IOException("No file found for id " + this.fileId);
            }
        }
        return this.file;
    }

    public Object get(String key) throws IOException {
        return this.getFile().get(key);
    }

    public DBObject getMetadata() throws IOException {
        return this.getFile().getMetaData();
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public InputStream getData() throws IOException {
        InputStream fileStream = this.getFile().getInputStream();
        fileStream.skip(this.chunkSize * this.chunkId);
        return fileStream;
    }

    public long getLength() throws IOException {
        return this.fileLength;
    }

    public String[] getLocations() throws IOException {
        List<String> hosts = this.inputURI.getHosts();
        return hosts.toArray(new String[hosts.size()]);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.inputURI.toString());
        out.write(this.fileId.toByteArray());
        out.writeInt(this.chunkId);
        out.writeLong(this.fileLength);
        out.writeInt(this.chunkSize);
    }

    public void readFields(DataInput in) throws IOException {
        this.inputURI = new MongoClientURI(in.readUTF());
        byte[] oidBytes = new byte[12];
        in.readFully(oidBytes);
        this.fileId = new ObjectId(oidBytes);
        this.chunkId = in.readInt();
        this.fileLength = in.readLong();
        this.chunkSize = in.readInt();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GridFSSplit{");
        if (this.inputURI != null) {
            sb.append("inputURI hosts=").append(this.inputURI.getHosts()).append(", ");
        }
        if (this.fileId != null) {
            sb.append("fileId=").append(this.fileId).append(", ");
        }
        return sb.append("chunkSize=").append(this.chunkSize).append(", fileLength=").append(this.fileLength).append(", chunkId=").append(this.chunkId).append("}").toString();
    }

    public int hashCode() {
        int hash = null == this.inputURI ? 0 : this.inputURI.hashCode();
        hash = hash * 31 + (null == this.fileId ? 0 : this.fileId.hashCode());
        return hash * 31 + this.chunkId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GridFSSplit) {
            GridFSSplit other = (GridFSSplit)((Object)obj);
            return (null == this.inputURI ? null == other.inputURI : this.inputURI.equals(other.inputURI)) && this.fileId.equals(other.fileId) && this.chunkId == other.chunkId;
        }
        return false;
    }
}

