/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.DBCursor;
import com.mongodb.MongoException;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.util.MongoConfigUtil;
import com.mongodb.hadoop.util.MongoPathRetriever;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordReader
extends RecordReader<Object, BSONObject> {
    private BSONObject current;
    private final MongoInputSplit split;
    private final DBCursor cursor;
    private float seen = 0.0f;
    private float total;
    private static final Log LOG = LogFactory.getLog(MongoRecordReader.class);

    public MongoRecordReader(MongoInputSplit split) {
        this.split = split;
        this.cursor = split.getCursor();
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
            MongoConfigUtil.close(this.cursor.getCollection().getDB().getMongo());
        }
    }

    public Object getCurrentKey() {
        Object key = MongoPathRetriever.get(this.current, this.split.getKeyField());
        return null != key ? key : NullWritable.get();
    }

    public BSONObject getCurrentValue() {
        return this.current;
    }

    public float getProgress() {
        try {
            return this.cursor.hasNext() ? 0.0f : 1.0f;
        }
        catch (MongoException e) {
            return 1.0f;
        }
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        this.total = 1.0f;
    }

    public boolean nextKeyValue() {
        try {
            if (!this.cursor.hasNext()) {
                LOG.info((Object)("Read " + this.seen + " documents from:"));
                LOG.info((Object)this.split.toString());
                return false;
            }
            this.current = this.cursor.next();
            this.seen += 1.0f;
            return true;
        }
        catch (MongoException e) {
            LOG.error((Object)("Exception reading next key/val from mongo: " + e.getMessage()));
            return false;
        }
    }
}

