/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.io;

import com.mongodb.BasicDBObject;
import com.mongodb.hadoop.io.BSONWritableComparator;
import com.mongodb.hadoop.io.DataOutputOutputStreamAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.AbstractMapWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.Bits;

public class BSONWritable
implements WritableComparable {
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final Log LOG = LogFactory.getLog(BSONWritable.class);
    private BSONObject doc = new BasicBSONObject();

    public BSONWritable() {
    }

    public BSONWritable(BSONObject doc) {
        this();
        this.setDoc(doc);
    }

    public void setDoc(BSONObject doc) {
        this.doc = doc;
    }

    public BSONObject getDoc() {
        return this.doc;
    }

    public void write(DataOutput out) throws IOException {
        BasicBSONEncoder enc = new BasicBSONEncoder();
        BasicOutputBuffer buf = new BasicOutputBuffer();
        enc.set(buf);
        enc.putObject(this.doc);
        enc.done();
        buf.pipe(new DataOutputOutputStreamAdapter(out));
    }

    public void readFields(DataInput in) throws IOException {
        BasicBSONDecoder dec = new BasicBSONDecoder();
        BasicBSONCallback cb = new BasicBSONCallback();
        byte[] l = new byte[4];
        try {
            in.readFully(l);
            int dataLen = Bits.readInt(l);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("*** Expected DataLen: " + dataLen));
            }
            byte[] data = new byte[dataLen + 4];
            System.arraycopy(l, 0, data, 0, 4);
            in.readFully(data, 4, dataLen - 4);
            dec.decode(data, (BSONCallback)cb);
            this.doc = (BSONObject)cb.get();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Decoded a BSON Object: " + this.doc));
            }
        }
        catch (Exception e) {
            LOG.info((Object)("No Length Header available." + e));
            this.doc = new BasicDBObject();
        }
    }

    public String toString() {
        return "<BSONWritable:" + this.doc + ">";
    }

    protected synchronized void copy(Writable other) {
        if (other != null) {
            try {
                DataOutputBuffer out = new DataOutputBuffer();
                other.write((DataOutput)out);
                DataInputBuffer in = new DataInputBuffer();
                in.reset(out.getData(), out.getLength());
                this.readFields((DataInput)in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("map cannot be copied: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("source map cannot be null");
        }
    }

    public int compareTo(Object o) {
        return new BSONWritableComparator().compare((Object)this, o);
    }

    protected static void dumpBytes(BasicOutputBuffer buf) {
        BSONWritable.dumpBytes(buf.toByteArray());
    }

    protected static void dumpBytes(byte[] buffer) {
        StringBuilder sb = new StringBuilder(2 + 3 * buffer.length);
        for (byte b : buffer) {
            sb.append("0x").append((char)HEX_CHAR[(b & 0xF0) >> 4]).append((char)HEX_CHAR[b & 0xF]).append(" ");
        }
        LOG.info((Object)("Byte Dump: " + sb));
    }

    public static Object toBSON(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Text) {
            return x.toString();
        }
        if (x instanceof BSONWritable) {
            return ((BSONWritable)x).getDoc();
        }
        if (x instanceof Writable) {
            if (x instanceof AbstractMapWritable) {
                if (!(x instanceof Map)) {
                    throw new IllegalArgumentException(String.format("Cannot turn %s into BSON, since it does not implement java.util.Map.", x.getClass().getName()));
                }
                Map map = (Map)x;
                BasicBSONObject bson = new BasicBSONObject();
                for (Map.Entry entry : map.entrySet()) {
                    bson.put(((Writable)entry.getKey()).toString(), BSONWritable.toBSON(entry.getValue()));
                }
                return bson;
            }
            if (x instanceof ArrayWritable) {
                Writable[] o = ((ArrayWritable)x).get();
                Object[] a = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    a[i] = BSONWritable.toBSON(o[i]);
                }
                return a;
            }
            if (x instanceof NullWritable) {
                return null;
            }
            if (x instanceof BooleanWritable) {
                return ((BooleanWritable)x).get();
            }
            if (x instanceof BytesWritable) {
                return ((BytesWritable)x).getBytes();
            }
            if (x instanceof ByteWritable) {
                return ((ByteWritable)x).get();
            }
            if (x instanceof DoubleWritable) {
                return ((DoubleWritable)x).get();
            }
            if (x instanceof FloatWritable) {
                return Float.valueOf(((FloatWritable)x).get());
            }
            if (x instanceof LongWritable) {
                return ((LongWritable)x).get();
            }
            if (x instanceof IntWritable) {
                return ((IntWritable)x).get();
            }
        }
        return x;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BSONWritable other = (BSONWritable)obj;
        return this.doc == other.doc || this.doc != null && this.doc.equals(other.doc);
    }

    public int hashCode() {
        return this.doc != null ? this.doc.hashCode() : 0;
    }

    static {
        WritableComparator.define(BSONWritable.class, (WritableComparator)new BSONWritableComparator());
    }
}

