/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.mapred.input.BSONFileRecordReader;
import com.mongodb.hadoop.mapred.input.BSONFileSplit;
import com.mongodb.hadoop.splitter.BSONSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class BSONFileInputFormat
extends FileInputFormat {
    protected boolean isSplitable(FileSystem fs, Path filename) {
        CompressionCodec codec = new CompressionCodecFactory(fs.getConf()).getCodec(filename);
        return null == codec;
    }

    public org.apache.hadoop.mapred.FileSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        BSONSplitter splitter = new BSONSplitter();
        splitter.setConf((Configuration)job);
        FileStatus[] inputFiles = this.listStatus(job);
        ArrayList<BSONFileSplit> results = new ArrayList<BSONFileSplit>();
        for (FileStatus file : inputFiles) {
            FileSystem fs = FileSystem.get((URI)file.getPath().toUri(), (Configuration)job);
            if (!this.isSplitable(fs, file.getPath())) {
                LOG.info((Object)("File " + file.getPath() + " is compressed so " + "cannot be split."));
                com.mongodb.hadoop.input.BSONFileSplit delegate = splitter.createFileSplit(file, fs, 0L, file.getLen());
                results.add(new BSONFileSplit(delegate.getPath(), delegate.getStart(), delegate.getLength(), delegate.getLocations()));
                continue;
            }
            splitter.setInputPath(file.getPath());
            Path splitFilePath = BSONSplitter.getSplitsFilePath(file.getPath(), (Configuration)job);
            try {
                splitter.loadSplitsFromSplitFile(file, splitFilePath);
            }
            catch (BSONSplitter.NoSplitFileException nsfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("No split file for %s; building split file", file.getPath()));
                }
                splitter.readSplitsForFile(file);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("BSONSplitter found %d splits.", splitter.getAllSplits().size()));
            }
            for (FileSplit fileSplit : splitter.getAllSplits()) {
                BSONFileSplit fsplit = new BSONFileSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations());
                fsplit.setKeyField(MongoConfigUtil.getInputKey((Configuration)job));
                results.add(fsplit);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Total of %d found.", results.size()));
        }
        return results.toArray(new BSONFileSplit[results.size()]);
    }

    public RecordReader<NullWritable, BSONWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        org.apache.hadoop.mapred.FileSplit fileSplit = (org.apache.hadoop.mapred.FileSplit)split;
        FileSystem fs = FileSystem.get((URI)fileSplit.getPath().toUri(), (Configuration)job);
        if (split instanceof BSONFileSplit || !this.isSplitable(fs, fileSplit.getPath())) {
            BSONFileRecordReader reader = new BSONFileRecordReader();
            reader.initialize(split, (Configuration)job);
            return reader;
        }
        BSONSplitter splitter = new BSONSplitter();
        splitter.setConf((Configuration)job);
        splitter.setInputPath(fileSplit.getPath());
        FileSplit newStyleFileSplit = new FileSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations());
        long start = splitter.getStartingPositionForSplit(newStyleFileSplit);
        BSONFileRecordReader reader = new BSONFileRecordReader(start);
        reader.initialize((InputSplit)fileSplit, (Configuration)job);
        return reader;
    }
}

