/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.mapred.input.MongoRecordReader;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.splitter.MongoSplitterFactory;
import com.mongodb.hadoop.splitter.SplitFailedException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;

public class MongoInputFormat
implements InputFormat<BSONWritable, BSONWritable> {
    private static final Log LOG = LogFactory.getLog(MongoInputFormat.class);

    public RecordReader<BSONWritable, BSONWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) {
        if (!(split instanceof MongoInputSplit)) {
            throw new IllegalStateException("Creation of a new RecordReader requires a MongoInputSplit instance.");
        }
        MongoInputSplit mis = (MongoInputSplit)split;
        return new MongoRecordReader(mis);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        try {
            MongoSplitter splitterImpl = MongoSplitterFactory.getSplitter((Configuration)job);
            LOG.info((Object)("Using " + splitterImpl + " to calculate splits. (old mapreduce API)"));
            List<InputSplit> splits = splitterImpl.calculateSplits();
            return splits.toArray(new org.apache.hadoop.mapred.InputSplit[splits.size()]);
        }
        catch (SplitFailedException spfe) {
            throw new IOException(spfe);
        }
    }

    public boolean verifyConfiguration(Configuration conf) {
        return true;
    }
}

