/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.mapred.output.MongoRecordWriter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class MongoOutputFormat<K, V>
implements OutputFormat<K, V> {
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (MongoConfigUtil.getOutputURIs((Configuration)job).isEmpty()) {
            throw new IOException("No output URI is specified. You must set mongo.output.uri.");
        }
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return new MongoRecordWriter(job);
    }
}

