/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import com.mongodb.hadoop.input.BSONFileSplit;
import com.mongodb.hadoop.io.BSONWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.InputSplit;

public class BSONFileRecordReader
implements RecordReader<NullWritable, BSONWritable> {
    public static final long BSON_RR_POSITION_NOT_GIVEN = -1L;
    private final com.mongodb.hadoop.input.BSONFileRecordReader delegate;
    private long pos = 0L;

    public BSONFileRecordReader() {
        this(-1L);
    }

    public BSONFileRecordReader(long startingPosition) {
        this.delegate = new com.mongodb.hadoop.input.BSONFileRecordReader(startingPosition);
    }

    public void initialize(org.apache.hadoop.mapred.InputSplit inputSplit, Configuration conf) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        try {
            this.delegate.init((InputSplit)new BSONFileSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations()), conf);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next(NullWritable key, BSONWritable value) throws IOException {
        try {
            boolean result = this.delegate.nextKeyValue();
            value.setDoc(this.delegate.getCurrentValue());
            ++this.pos;
            return result;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public float getProgress() throws IOException {
        try {
            return this.delegate.getProgress();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public BSONWritable createValue() {
        return new BSONWritable();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

