/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;

public class BSONFileSplit
extends FileSplit {
    protected String keyField = "_id";

    public BSONFileSplit(Path file, long start, long length, String[] hosts) {
        super(file, start, length, hosts);
    }

    public BSONFileSplit() {
        this(null, 0L, 0L, null);
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.getKeyField());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.setKeyField(Text.readString((DataInput)in));
    }
}

