/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.bson.BasicBSONObject;

public class MongoRecordReader
implements RecordReader<BSONWritable, BSONWritable> {
    private static final Log LOG = LogFactory.getLog(MongoRecordReader.class);
    private final DBCursor cursor;
    private BSONWritable currentVal = new BSONWritable();
    private BSONWritable currentKey = new BSONWritable();
    private float seen = 0.0f;
    private float total;
    private String keyField;
    private MongoInputSplit split;

    public MongoRecordReader(MongoInputSplit split) {
        this.split = split;
        this.cursor = split.getCursor();
        this.keyField = split.getKeyField();
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
            MongoConfigUtil.close(this.cursor.getCollection().getDB().getMongo());
        }
    }

    public BSONWritable createKey() {
        return new BSONWritable();
    }

    public BSONWritable createValue() {
        return new BSONWritable();
    }

    public BSONWritable getCurrentKey() {
        return this.currentKey;
    }

    public BSONWritable getCurrentValue() {
        return this.currentVal;
    }

    public float getProgress() {
        try {
            if (this.cursor.hasNext()) {
                return 0.0f;
            }
            return 1.0f;
        }
        catch (MongoException e) {
            return 1.0f;
        }
    }

    public long getPos() {
        return 0L;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        this.total = 1.0f;
    }

    public boolean nextKeyValue() throws IOException {
        try {
            if (!this.cursor.hasNext()) {
                LOG.info((Object)("Read " + this.seen + " documents from:"));
                LOG.info((Object)this.split.toString());
                return false;
            }
            DBObject next = this.cursor.next();
            this.currentVal.setDoc(next);
            this.currentKey.setDoc(new BasicBSONObject("_id", next.get("_id")));
            this.seen += 1.0f;
            return true;
        }
        catch (MongoException e) {
            throw new IOException("Couldn't get next key/value from mongodb: ", e);
        }
    }

    public boolean next(BSONWritable key, BSONWritable value) throws IOException {
        if (this.nextKeyValue()) {
            key.setDoc(this.currentKey.getDoc());
            value.setDoc(this.currentVal.getDoc());
            return true;
        }
        LOG.info((Object)"Cursor exhausted.");
        return false;
    }
}

