/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.output;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.hadoop.MongoOutput;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.io.MongoUpdateWritable;
import com.mongodb.hadoop.output.MongoOutputCommitter;
import com.mongodb.hadoop.util.CompatUtils;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordWriter<K, V>
extends RecordWriter<K, V> {
    private static final Log LOG = LogFactory.getLog(MongoRecordWriter.class);
    private final DBCollection collection;
    private final CompatUtils.TaskAttemptContext context;
    private final BSONWritable bsonWritable;
    private FSDataOutputStream outputStream;

    public MongoRecordWriter(DBCollection c, CompatUtils.TaskAttemptContext ctx) {
        this.collection = c;
        this.context = ctx;
        this.bsonWritable = new BSONWritable();
        try {
            FileSystem fs = FileSystem.get((Configuration)ctx.getConfiguration());
            Path outputPath = MongoOutputCommitter.getTaskAttemptPath(ctx);
            LOG.info((Object)("Writing to temporary file: " + outputPath.toString()));
            this.outputStream = fs.create(outputPath, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open temporary file for buffering Mongo output", e);
        }
    }

    public MongoRecordWriter(DBCollection c, TaskAttemptContext ctx) {
        this(c, CompatUtils.getTaskAttemptContext(ctx));
    }

    public void close(TaskAttemptContext context) {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Could not close output stream", (Throwable)e);
            }
        }
        MongoConfigUtil.close(this.collection.getDB().getMongo());
    }

    public void write(K key, V value) throws IOException {
        if (value instanceof MongoUpdateWritable) {
            this.outputStream.writeInt(1);
            ((MongoUpdateWritable)value).write((DataOutput)this.outputStream);
        } else {
            BasicDBObject o = new BasicDBObject();
            if (key instanceof BSONWritable) {
                o.put("_id", ((BSONWritable)key).getDoc());
            } else if (key instanceof BSONObject) {
                o.put("_id", key);
            } else {
                o.put("_id", BSONWritable.toBSON(key));
            }
            if (value instanceof BSONWritable) {
                o.putAll(((BSONWritable)value).getDoc());
            } else if (value instanceof MongoOutput) {
                ((MongoOutput)value).appendAsValue(o);
            } else if (value instanceof BSONObject) {
                o.putAll((BSONObject)value);
            } else if (value instanceof Map) {
                o.putAll((Map)value);
            } else {
                o.put("value", BSONWritable.toBSON(value));
            }
            this.outputStream.writeInt(0);
            this.bsonWritable.setDoc(o);
            this.bsonWritable.write((DataOutput)this.outputStream);
        }
    }

    public void ensureIndex(DBObject index, DBObject options) {
        this.collection.createIndex(index, options);
    }
}

