/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.hadoop.input.BSONFileSplit;
import com.mongodb.hadoop.util.CompatUtils;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;
import org.bson.LazyBSONObject;

public class BSONSplitter
extends Configured
implements Tool {
    private static final String CORE_JAR = "mongo-hadoop-core.jar";
    private static final Log LOG = LogFactory.getLog(BSONSplitter.class);
    private ArrayList<BSONFileSplit> splitsList;
    private Path inputPath;
    private final BasicBSONCallback callback = new BasicBSONCallback();
    private final LazyBSONCallback lazyCallback = new LazyBSONCallback();
    private final LazyBSONDecoder lazyDec = new LazyBSONDecoder();
    private final BasicBSONDecoder bsonDec = new BasicBSONDecoder();
    private final BasicBSONEncoder bsonEnc = new BasicBSONEncoder();

    public void setInputPath(Path p) {
        this.inputPath = p;
    }

    public ArrayList<BSONFileSplit> getAllSplits() {
        if (this.splitsList == null) {
            return new ArrayList<BSONFileSplit>(0);
        }
        return this.splitsList;
    }

    public BSONFileSplit createFileSplitFromBSON(BSONObject obj, FileSystem fs, FileStatus inputFile) throws IOException {
        long start = (Long)obj.get("s");
        long splitLen = (Long)obj.get("l");
        return this.createFileSplit(inputFile, fs, start, splitLen);
    }

    public BSONFileSplit createFileSplit(FileStatus inFile, FileSystem fs, long splitStart, long splitLen) {
        BSONFileSplit split;
        try {
            boolean isLocatedFileStatus = CompatUtils.isInstance(inFile, "org.apache.hadoop.fs.LocatedFileStatus", this.getConf(), FileStatus.class);
            BlockLocation[] blkLocations = isLocatedFileStatus ? (BlockLocation[])CompatUtils.invokeMethod(FileStatus.class, inFile, "getBlockLocations", new Object[0], new Class[0]) : fs.getFileBlockLocations(inFile, splitStart, splitLen);
            int blockIndex = BSONSplitter.getBlockIndex(blkLocations, splitStart);
            split = new BSONFileSplit(inFile.getPath(), splitStart, splitLen, blkLocations[blockIndex].getHosts());
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't find block locations when constructing input split from byte offset. Using non-block-aware input split; " + e.getMessage()));
            split = new BSONFileSplit(inFile.getPath(), splitStart, splitLen, null);
        }
        split.setKeyField(MongoConfigUtil.getInputKey(this.getConf()));
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSplitsFromSplitFile(FileStatus inputFile, Path splitFile) throws NoSplitFileException, IOException {
        ArrayList<BSONFileSplit> splits = new ArrayList<BSONFileSplit>();
        FileSystem fs = splitFile.getFileSystem(this.getConf());
        FSDataInputStream fsDataStream = null;
        try {
            FileStatus splitFileStatus;
            try {
                splitFileStatus = fs.getFileStatus(splitFile);
                LOG.info((Object)("Found split file at : " + splitFileStatus));
            }
            catch (Exception e) {
                throw new NoSplitFileException();
            }
            fsDataStream = fs.open(splitFile);
            while (fsDataStream.getPos() < splitFileStatus.getLen()) {
                this.callback.reset();
                this.bsonDec.decode((InputStream)fsDataStream, (BSONCallback)this.callback);
                BSONObject splitInfo = (BSONObject)this.callback.get();
                splits.add(this.createFileSplitFromBSON(splitInfo, fs, inputFile));
            }
        }
        finally {
            if (null != fsDataStream) {
                fsDataStream.close();
            }
        }
        this.splitsList = splits;
    }

    public static long getSplitSize(Configuration conf, FileStatus file) {
        long maxSize = conf.getLong("mapreduce.input.fileinputformat.split.maxsize", conf.getLong("mapred.max.split.size", Long.MAX_VALUE));
        long minSize = Math.max(1L, conf.getLong("mapreduce.input.fileinputformat.split.minsize", conf.getLong("mapred.min.split.size", 1L)));
        if (file != null) {
            long fileBlockSize = file.getBlockSize();
            return Math.max(minSize, Math.min(maxSize, fileBlockSize));
        }
        long blockSize = conf.getLong("dfs.blockSize", 0x4000000L);
        return Math.max(minSize, Math.min(maxSize, blockSize));
    }

    public void readSplitsForFile(FileStatus file) throws IOException {
        long length = file.getLen();
        if (!MongoConfigUtil.getBSONReadSplits(this.getConf())) {
            LOG.info((Object)("Reading splits is disabled - constructing single split for " + file));
            FileSystem fs = file.getPath().getFileSystem(this.getConf());
            BSONFileSplit onesplit = this.createFileSplit(file, fs, 0L, length);
            ArrayList<BSONFileSplit> splits = new ArrayList<BSONFileSplit>();
            splits.add(onesplit);
            this.splitsList = splits;
            return;
        }
        if (length != 0L) {
            this.splitsList = (ArrayList)this.splitFile(file);
            this.writeSplits();
        } else {
            LOG.warn((Object)"Zero-length file, skipping split calculation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BSONFileSplit> splitFile(FileStatus file) throws IOException {
        Path path = file.getPath();
        ArrayList<BSONFileSplit> splits = new ArrayList<BSONFileSplit>();
        FileSystem fs = path.getFileSystem(this.getConf());
        long length = file.getLen();
        int numDocsRead = 0;
        long splitSize = BSONSplitter.getSplitSize(this.getConf(), file);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating splits for " + path + " of up to " + splitSize + " bytes."));
        }
        FSDataInputStream fsDataStream = fs.open(path);
        long curSplitLen = 0L;
        long curSplitStart = 0L;
        try {
            while (fsDataStream.getPos() + 1L < length) {
                this.lazyCallback.reset();
                this.lazyDec.decode((InputStream)fsDataStream, (BSONCallback)this.lazyCallback);
                LazyBSONObject bo = (LazyBSONObject)this.lazyCallback.get();
                int bsonDocSize = bo.getBSONSize();
                if (curSplitLen + (long)bsonDocSize >= splitSize) {
                    BSONFileSplit split = this.createFileSplit(file, fs, curSplitStart, curSplitLen);
                    splits.add(split);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Creating new split (%d) %s", new Object[]{splits.size(), split}));
                    }
                    curSplitStart = fsDataStream.getPos() - (long)bsonDocSize;
                    curSplitLen = 0L;
                }
                curSplitLen += (long)bsonDocSize;
                if (++numDocsRead % 1000 != 0) continue;
                float splitProgress = 100.0f * ((float)fsDataStream.getPos() / (float)length);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Read %d docs calculating splits for %s; %3.3f%% complete.", numDocsRead, file.getPath(), Float.valueOf(splitProgress)));
            }
            if (curSplitLen > 0L) {
                BSONFileSplit split = this.createFileSplit(file, fs, curSplitStart, curSplitLen);
                splits.add(split);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Final split (%d) %s", splits.size(), split.getPath()));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed splits calculation for " + file.getPath()));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("IOException: " + e));
        }
        finally {
            fsDataStream.close();
        }
        return splits;
    }

    public void writeSplits() throws IOException {
        if (!this.getConf().getBoolean("bson.split.write_splits", true)) {
            LOG.info((Object)"bson.split.write_splits is set to false - skipping writing splits to disk.");
            return;
        }
        LOG.info((Object)"Writing splits to disk.");
        if (this.splitsList == null) {
            LOG.info((Object)"No splits found, skipping write of splits file.");
        }
        Path outputPath = BSONSplitter.getSplitsFilePath(this.inputPath, this.getConf());
        FileSystem pathFileSystem = outputPath.getFileSystem(this.getConf());
        FSDataOutputStream fsDataOut = null;
        try {
            fsDataOut = pathFileSystem.create(outputPath, false);
            for (FileSplit fileSplit : this.splitsList) {
                DBObject splitObj = BasicDBObjectBuilder.start().add("s", fileSplit.getStart()).add("l", fileSplit.getLength()).get();
                byte[] encodedObj = this.bsonEnc.encode(splitObj);
                fsDataOut.write(encodedObj, 0, encodedObj.length);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Could not create splits file: " + e.getMessage()));
            throw e;
        }
        finally {
            if (fsDataOut != null) {
                fsDataOut.close();
            }
        }
    }

    public void readSplits() throws IOException {
        this.splitsList = new ArrayList();
        if (this.inputPath == null) {
            throw new IllegalStateException("Input path has not been set.");
        }
        FileSystem fs = this.inputPath.getFileSystem(this.getConf());
        FileStatus file = fs.getFileStatus(this.inputPath);
        this.readSplitsForFile(file);
    }

    private static int getBlockIndex(BlockLocation[] blockLocations, long offset) {
        for (int i = 0; i < blockLocations.length; ++i) {
            BlockLocation bl = blockLocations[i];
            if (bl.getOffset() > offset || offset >= bl.getOffset() + bl.getLength()) continue;
            return i;
        }
        BlockLocation lastBlock = blockLocations[blockLocations.length - 1];
        long fileLength = lastBlock.getOffset() + lastBlock.getLength() - 1L;
        throw new IllegalArgumentException(String.format("Offset %d is outside the file [0..%d].", offset, fileLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getStartingPositionForSplit(FileSplit split) throws IOException {
        ArrayList<BSONFileSplit> splits;
        FileSystem fs = split.getPath().getFileSystem(this.getConf());
        FileStatus file = fs.getFileStatus(split.getPath());
        if (MongoConfigUtil.getBSONReadSplits(this.getConf())) {
            try {
                this.loadSplitsFromSplitFile(file, BSONSplitter.getSplitsFilePath(file.getPath(), this.getConf()));
            }
            catch (NoSplitFileException e) {
                this.readSplitsForFile(file);
            }
            splits = this.getAllSplits();
        } else {
            splits = (ArrayList<BSONFileSplit>)this.splitFile(file);
        }
        BSONFileSplit[] splitsArr = new BSONFileSplit[splits.size()];
        splits.toArray(splitsArr);
        long previousStart = split.getStart();
        long startIterating = 0L;
        for (BSONFileSplit bfs : splitsArr) {
            if (bfs.getStart() >= split.getStart()) {
                startIterating = previousStart;
                break;
            }
            previousStart = bfs.getStart();
        }
        FSDataInputStream fsDataStream = null;
        long pos = startIterating;
        try {
            fsDataStream = fs.open(split.getPath());
            fsDataStream.seek(pos);
            while (pos < split.getStart()) {
                this.callback.reset();
                this.bsonDec.decode((InputStream)fsDataStream, (BSONCallback)this.callback);
                pos = fsDataStream.getPos();
            }
        }
        finally {
            if (null != fsDataStream) {
                fsDataStream.close();
            }
        }
        return pos;
    }

    public static Path getSplitsFilePath(Path filePath, Configuration conf) {
        String splitsPath = MongoConfigUtil.getBSONSplitsPath(conf);
        String splitsFileName = "." + filePath.getName() + ".splits";
        if (null == splitsPath) {
            return new Path(filePath.getParent(), splitsFileName);
        }
        return new Path(splitsPath, splitsFileName);
    }

    private void printUsage() {
        System.err.println("USAGE: hadoop jar mongo-hadoop-core.jar " + ((Object)((Object)this)).getClass().getName() + " <fileName> [-c compressionCodec] [-o outputDirectory]\n\n" + "Make sure to use the full path, including scheme, for " + "input and output paths.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        DefaultCodec codec;
        if (args.length < 1) {
            this.printUsage();
            return 1;
        }
        Path filePath = new Path(args[0]);
        String compressorName = null;
        String outputDirectoryStr = null;
        for (int i = 1; i < args.length; ++i) {
            if ("-c".equals(args[i]) && args.length > i) {
                compressorName = args[++i];
                continue;
            }
            if ("-o".equals(args[i]) && args.length > i) {
                outputDirectoryStr = args[++i];
                continue;
            }
            System.err.println("unrecognized option: " + args[i]);
            this.printUsage();
            return 1;
        }
        Path outputDirectory = null == outputDirectoryStr ? filePath.getParent() : new Path(outputDirectoryStr);
        if (null == compressorName) {
            codec = new DefaultCodec();
        } else {
            Class<?> codecClass = Class.forName(compressorName);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.getConf());
        }
        if (codec instanceof Configurable) {
            ((Configurable)codec).setConf(this.getConf());
        }
        MongoConfigUtil.setBSONWriteSplits(this.getConf(), false);
        FileSystem inputFS = FileSystem.get((URI)filePath.toUri(), (Configuration)this.getConf());
        FileSystem outputFS = FileSystem.get((URI)outputDirectory.toUri(), (Configuration)this.getConf());
        FSDataInputStream inputStream = inputFS.open(filePath);
        Path splitFilePath = BSONSplitter.getSplitsFilePath(filePath, this.getConf());
        try {
            this.loadSplitsFromSplitFile(inputFS.getFileStatus(filePath), splitFilePath);
        }
        catch (NoSplitFileException e) {
            LOG.info((Object)("did not find .splits file in " + splitFilePath.toUri()));
            this.setInputPath(filePath);
            this.readSplits();
        }
        ArrayList<BSONFileSplit> splits = this.getAllSplits();
        LOG.info((Object)("compressing " + splits.size() + " splits."));
        byte[] buf = new byte[0x100000];
        for (int i = 0; i < splits.size(); ++i) {
            Path splitOutputPath = new Path(outputDirectory, filePath.getName() + "-" + i + codec.getDefaultExtension());
            Compressor compressor = CodecPool.getCompressor((CompressionCodec)codec);
            CompressionOutputStream compressionOutputStream = null;
            try {
                compressionOutputStream = codec.createOutputStream((OutputStream)outputFS.create(splitOutputPath), compressor);
                int totalBytes = 0;
                int bytesRead = 0;
                BSONFileSplit split = (BSONFileSplit)((Object)splits.get(i));
                inputStream.seek(split.getStart());
                LOG.info((Object)("writing " + splitOutputPath.toUri() + "."));
                while ((long)totalBytes < split.getLength() && bytesRead >= 0) {
                    bytesRead = inputStream.read(buf, 0, (int)Math.min((long)buf.length, split.getLength() - (long)totalBytes));
                    if (bytesRead <= 0) continue;
                    compressionOutputStream.write(buf, 0, bytesRead);
                    totalBytes += bytesRead;
                }
                continue;
            }
            finally {
                if (compressionOutputStream != null) {
                    compressionOutputStream.close();
                }
                CodecPool.returnCompressor((Compressor)compressor);
            }
        }
        LOG.info((Object)"done.");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new BSONSplitter(), (String[])args));
    }

    public static class NoSplitFileException
    extends Exception {
    }
}

