/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.BSONObject;

public class MongoPaginatingSplitter
extends MongoCollectionSplitter {
    public MongoPaginatingSplitter() {
    }

    public MongoPaginatingSplitter(Configuration conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        Configuration conf = this.getConfiguration();
        if (!MongoConfigUtil.isRangeQueryEnabled(conf)) {
            throw new IllegalArgumentException("Cannot split using " + this.getClass().getName() + " when " + "mongo.input.split.use_range_queries" + " is disabled.");
        }
        DBObject splitKeyObj = MongoConfigUtil.getInputSplitKey(conf);
        Set<String> splitKeys = splitKeyObj.keySet();
        if (splitKeys.size() > 1) {
            throw new IllegalArgumentException("Cannot split using " + this.getClass().getName() + " when " + "mongo.input.split.split_key_pattern" + " describes a " + "compound key.");
        }
        String splitKey = splitKeys.iterator().next();
        BasicDBObject splitKeyProjection = new BasicDBObject(splitKey, (Object)1);
        if (!splitKey.equals("_id")) {
            splitKeyProjection.put("_id", (Object)0);
        }
        int minDocs = MongoConfigUtil.getInputSplitMinDocs(conf);
        DBCollection inputCollection = MongoConfigUtil.getInputCollection(conf);
        DBObject query = MongoConfigUtil.getQuery(conf);
        BSONObject rangeObj = null;
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Object minBound = null;
        try {
            Object maxBound;
            do {
                DBCursor cursor;
                if (null == minBound) {
                    cursor = inputCollection.find(query, splitKeyProjection);
                } else {
                    if (null == rangeObj) {
                        rangeObj = new BasicDBObjectBuilder().push(splitKey).add("$gte", minBound).pop().get();
                        rangeObj.putAll(query);
                    } else {
                        ((DBObject)rangeObj.get(splitKey)).put("$gte", minBound);
                    }
                    cursor = inputCollection.find((DBObject)rangeObj, splitKeyProjection);
                }
                cursor = cursor.sort(splitKeyObj).skip(minDocs).limit(1).setOptions(16);
                maxBound = cursor.hasNext() ? cursor.next().get(splitKey) : null;
                BasicDBObject lowerBound = null;
                BasicDBObject upperBound = null;
                if (minBound != null) {
                    lowerBound = new BasicDBObject(splitKey, minBound);
                }
                if (maxBound != null) {
                    upperBound = new BasicDBObject(splitKey, maxBound);
                }
                splits.add(this.createRangeQuerySplit(lowerBound, upperBound, query));
                minBound = maxBound;
            } while (maxBound != null);
        }
        finally {
            MongoConfigUtil.close(inputCollection.getDB().getMongo());
        }
        return splits;
    }
}

