/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public abstract class MongoSplitter {
    private Configuration configuration;

    public MongoSplitter() {
    }

    public MongoSplitter(Configuration configuration) {
        this.setConfiguration(configuration);
    }

    public void setConfiguration(Configuration conf) {
        this.configuration = conf;
    }

    public abstract List<InputSplit> calculateSplits() throws SplitFailedException;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static List<InputSplit> filterEmptySplits(List<InputSplit> splits) {
        ArrayList<InputSplit> results = new ArrayList<InputSplit>(splits.size());
        for (InputSplit split : splits) {
            MongoInputSplit mis = (MongoInputSplit)split;
            if (mis.getCursor().hasNext()) {
                results.add(mis);
                continue;
            }
            MongoConfigUtil.close(mis.getCursor().getCollection().getDB().getMongo());
        }
        return results;
    }
}

