/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.util.JSON;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiCollectionSplitBuilder {
    private List<CollectionSplitterConf> collectionSplitters = new LinkedList<CollectionSplitterConf>();

    public MultiCollectionSplitBuilder addConf(CollectionSplitterConf conf) {
        this.collectionSplitters.add(conf);
        return this;
    }

    @Deprecated
    public MultiCollectionSplitBuilder add(MongoURI inputURI, MongoURI authURI, boolean noTimeout, DBObject fields, DBObject sort, DBObject query, boolean useRangeQuery, Class<? extends MongoSplitter> splitClass) {
        return this.add(new MongoClientURI(inputURI.toString()), new MongoClientURI(authURI.toString()), noTimeout, fields, sort, query, useRangeQuery, splitClass);
    }

    public MultiCollectionSplitBuilder add(MongoClientURI inputURI, MongoClientURI authURI, boolean noTimeout, DBObject fields, DBObject sort, DBObject query, boolean useRangeQuery, Class<? extends MongoSplitter> splitClass) {
        return this.addConf(new CollectionSplitterConf(inputURI, authURI, noTimeout, fields, sort, query, useRangeQuery, splitClass));
    }

    public String toJSON() {
        BasicDBList returnVal = new BasicDBList();
        for (CollectionSplitterConf conf : this.collectionSplitters) {
            returnVal.add(new BasicDBObject(conf.toConfigMap()));
        }
        return JSON.serialize(returnVal);
    }

    public static class CollectionSplitterConf {
        private MongoClientURI inputURI = null;
        private MongoClientURI authURI = null;
        private boolean noTimeout = false;
        private DBObject fields = null;
        private DBObject sort = null;
        private DBObject query = null;
        private boolean useRangeQuery = false;
        private Class<? extends MongoSplitter> splitClass;

        public CollectionSplitterConf(MongoClientURI inputURI, MongoClientURI authURI, boolean noTimeout, DBObject fields, DBObject sort, DBObject query, boolean useRangeQuery, Class<? extends MongoSplitter> splitClass) {
            this.inputURI = inputURI;
            this.authURI = authURI;
            this.noTimeout = noTimeout;
            this.fields = fields;
            this.sort = sort;
            this.query = query;
            this.useRangeQuery = useRangeQuery;
            this.splitClass = splitClass;
        }

        public Map<String, String> toConfigMap() {
            HashMap<String, String> outMap = new HashMap<String, String>();
            if (this.inputURI != null) {
                outMap.put("mongo.input.uri", this.inputURI.toString());
            }
            if (this.authURI != null) {
                outMap.put("mongo.auth.uri", this.authURI.toString());
            }
            outMap.put("mongo.input.notimeout", this.noTimeout + "");
            if (this.fields != null) {
                outMap.put("mongo.input.fields", JSON.serialize(this.fields));
            }
            if (this.sort != null) {
                outMap.put("mongo.input.sort", JSON.serialize(this.sort));
            }
            if (this.query != null) {
                outMap.put("mongo.input.query", JSON.serialize(this.query));
            }
            outMap.put("mongo.input.split.use_range_queries", this.useRangeQuery ? "true" : "false");
            if (this.splitClass != null) {
                outMap.put("mongo.splitter.class", this.splitClass.getCanonicalName());
            }
            return outMap;
        }
    }
}

