/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.splitter.MongoSplitterFactory;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class MultiMongoCollectionSplitter
extends MongoSplitter {
    public static final String MULTI_COLLECTION_CONF_KEY = "mongo.input.multi_uri.json";
    private static final Log LOG = LogFactory.getLog(MultiMongoCollectionSplitter.class);

    public MultiMongoCollectionSplitter() {
    }

    public MultiMongoCollectionSplitter(Configuration conf) {
        super(conf);
    }

    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        List<MongoClientURI> inputURIs = MongoConfigUtil.getMongoURIs(this.getConfiguration(), "mongo.input.uri");
        LinkedList<InputSplit> returnVal = new LinkedList<InputSplit>();
        LinkedList<MongoCollectionSplitter> splitters = new LinkedList<MongoCollectionSplitter>();
        if (inputURIs.size() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using global split settings for multiple URIs specified.");
            }
            for (MongoClientURI mongoClientURI : inputURIs) {
                Configuration confForThisUri = new Configuration(this.getConfiguration());
                MongoConfigUtil.setInputURI(confForThisUri, mongoClientURI);
                confForThisUri.set("mongo.splitter.class", "");
                MongoCollectionSplitter splitter = MongoSplitterFactory.getSplitterByStats(mongoClientURI, confForThisUri);
                splitters.add(splitter);
            }
        } else {
            DBObject multiUriConfig;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Loading multiple input URIs from JSON stored in mongo.input.multi_uri.json");
            }
            if (!((multiUriConfig = MongoConfigUtil.getDBObject(this.getConfiguration(), MULTI_COLLECTION_CONF_KEY)) instanceof List)) {
                throw new IllegalArgumentException("Invalid JSON format in multi uri config key: Must be an array where each element is an object describing the URI and config options for each split.");
            }
            for (Object obj : (List)((Object)multiUriConfig)) {
                MongoCollectionSplitter splitter;
                MongoClientURI inputURI;
                Configuration confForThisUri;
                try {
                    Map configMap = (Map)obj;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("building config from " + configMap.toString()));
                    }
                    confForThisUri = MongoConfigUtil.buildConfiguration(configMap);
                    inputURI = MongoConfigUtil.getInputURI(confForThisUri);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Invalid JSON format in multi uri config key: each config item must be an object with keys/values describing options for each URI.");
                }
                Class<? extends MongoSplitter> splitterClass = MongoConfigUtil.getSplitterClass(confForThisUri);
                if (splitterClass != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Using custom Splitter class for namespace: %s.%s; hosts: %s", inputURI.getDatabase(), inputURI.getCollection(), inputURI.getHosts()));
                    }
                    if (splitterClass == MultiMongoCollectionSplitter.class) {
                        throw new IllegalArgumentException("Can't nest uses of MultiMongoCollectionSplitter");
                    }
                    MongoCollectionSplitter collectionSplitter = (MongoCollectionSplitter)ReflectionUtils.newInstance(splitterClass, (Configuration)confForThisUri);
                    collectionSplitter.setConfiguration(confForThisUri);
                    splitter = collectionSplitter;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Fetching collection stats on namespace: %s.%s; hosts: %s to choose splitter implementation.", inputURI.getDatabase(), inputURI.getCollection(), inputURI.getHosts()));
                    }
                    splitter = MongoSplitterFactory.getSplitterByStats(inputURI, confForThisUri);
                }
                splitters.add(splitter);
            }
        }
        for (MongoSplitter mongoSplitter : splitters) {
            returnVal.addAll(mongoSplitter.calculateSplits());
        }
        return returnVal;
    }
}

