/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class ShardChunkMongoSplitter
extends MongoCollectionSplitter {
    private static final Log LOG = LogFactory.getLog(ShardChunkMongoSplitter.class);

    public ShardChunkMongoSplitter() {
    }

    public ShardChunkMongoSplitter(Configuration conf) {
        super(conf);
    }

    List<InputSplit> calculateSplitsFromChunks(List<DBObject> chunks, Map<String, List<String>> shardsMap) throws SplitFailedException {
        boolean targetShards = MongoConfigUtil.canReadSplitsFromShards(this.getConfiguration());
        List<String> mongosHostNames = MongoConfigUtil.getInputMongosHosts(this.getConfiguration());
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.getConfiguration());
        if (targetShards && mongosHostNames.size() > 0) {
            throw new SplitFailedException("Setting both mongo.input.split.read_from_shards and mongo.input.mongos_hosts does not make sense. ");
        }
        HashMap<String, String> mongosMap = null;
        if (mongosHostNames.size() > 0) {
            mongosMap = new HashMap<String, String>();
            for (String mongosHostName : mongosHostNames) {
                String[] hostAndPort = mongosHostName.split(":");
                mongosMap.put(hostAndPort[0], mongosHostName);
            }
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(chunks.size());
        for (DBObject chunk : chunks) {
            BasicDBObject chunkLowerBound = (BasicDBObject)chunk.get("min");
            BasicDBObject chunkUpperBound = (BasicDBObject)chunk.get("max");
            MongoInputSplit chunkSplit = this.createSplitFromBounds(chunkLowerBound, chunkUpperBound);
            chunkSplit.setInputURI(inputURI);
            String shard = (String)chunk.get("shard");
            if (targetShards) {
                List<String> shardHosts = shardsMap.get(shard);
                if (shardHosts == null) {
                    throw new SplitFailedException("Couldn't find shard ID: " + shard + " in config.shards.");
                }
                MongoClientURI newURI = ShardChunkMongoSplitter.rewriteURI(inputURI, shardHosts);
                chunkSplit.setInputURI(newURI);
            } else if (mongosMap != null) {
                String chunkHost;
                String[] hostAndPort;
                List<String> chunkHosts = shardsMap.get(shard);
                String mongosHost = null;
                Iterator<String> iterator = chunkHosts.iterator();
                while (iterator.hasNext() && (mongosHost = (String)mongosMap.get((hostAndPort = (chunkHost = iterator.next()).split(":"))[0])) == null) {
                }
                if (null == mongosHost) {
                    chunkSplit.setInputURI(inputURI);
                } else {
                    LOG.info((Object)("Will read split " + (Object)((Object)chunkSplit) + " from mongos " + mongosHost));
                    chunkSplit.setInputURI(ShardChunkMongoSplitter.rewriteURI(inputURI, mongosHost));
                }
            }
            chunkSplit.setKeyField(MongoConfigUtil.getInputKey(this.getConfiguration()));
            splits.add(chunkSplit);
        }
        if (MongoConfigUtil.isFilterEmptySplitsEnabled(this.getConfiguration())) {
            return ShardChunkMongoSplitter.filterEmptySplits(splits);
        }
        return splits;
    }

    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        Map<String, List<String>> shardsMap;
        DB configDB = this.getConfigDB();
        DBCollection chunksCollection = configDB.getCollection("chunks");
        try {
            shardsMap = this.getShardsMap();
        }
        catch (Exception e) {
            throw new SplitFailedException("Couldn't get shards information from config server", e);
        }
        return this.calculateSplitsFromChunks(chunksCollection.find().toArray(), shardsMap);
    }
}

