/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class ShardMongoSplitter
extends MongoCollectionSplitter {
    public ShardMongoSplitter() {
    }

    public ShardMongoSplitter(Configuration conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        ArrayList<InputSplit> returnVal = new ArrayList<InputSplit>();
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.getConfiguration());
        try {
            Map<String, List<String>> shardsMap = this.getShardsMap();
            for (Map.Entry<String, List<String>> entry : shardsMap.entrySet()) {
                List<String> shardHosts = entry.getValue();
                MongoInputSplit chunkSplit = this.createSplitFromBounds(null, null);
                chunkSplit.setInputURI(ShardMongoSplitter.rewriteURI(inputURI, shardHosts));
                returnVal.add(chunkSplit);
            }
        }
        finally {
            MongoConfigUtil.close(this.getConfigDB().getMongo());
        }
        if (MongoConfigUtil.isFilterEmptySplitsEnabled(this.getConfiguration())) {
            return ShardMongoSplitter.filterEmptySplits(returnVal);
        }
        return returnVal;
    }
}

