/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoClientURIBuilder;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class StandaloneMongoSplitter
extends MongoCollectionSplitter {
    private static final Log LOG = LogFactory.getLog(StandaloneMongoSplitter.class);

    public StandaloneMongoSplitter() {
    }

    public StandaloneMongoSplitter(Configuration conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        ArrayList<InputSplit> returnVal;
        DBObject splitKey = MongoConfigUtil.getInputSplitKey(this.getConfiguration());
        DBObject splitKeyMax = MongoConfigUtil.getMaxSplitKey(this.getConfiguration());
        DBObject splitKeyMin = MongoConfigUtil.getMinSplitKey(this.getConfiguration());
        int splitSize = MongoConfigUtil.getSplitSize(this.getConfiguration());
        DBCollection inputCollection = null;
        try {
            BasicDBList splitData;
            CommandResult data;
            MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.getConfiguration());
            MongoClientURI authURI = MongoConfigUtil.getAuthURI(this.getConfiguration());
            inputCollection = authURI != null ? MongoConfigUtil.getCollectionWithAuth(inputURI, authURI) : MongoConfigUtil.getCollection(inputURI);
            returnVal = new ArrayList<InputSplit>();
            String ns = inputCollection.getFullName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Running splitVector on namespace: %s.%s; hosts: %s", inputURI.getDatabase(), inputURI.getCollection(), inputURI.getHosts()));
            }
            DBObject cmd = BasicDBObjectBuilder.start("splitVector", ns).add("keyPattern", splitKey).add("min", splitKeyMin).add("max", splitKeyMax).add("force", false).add("maxChunkSize", splitSize).get();
            boolean ok = true;
            try {
                data = inputCollection.getDB().getSisterDB(inputURI.getDatabase()).command(cmd, ReadPreference.primary());
            }
            catch (MongoException e) {
                data = null;
                LOG.info((Object)e.getMessage(), (Throwable)e);
                if (e.getMessage().contains("unrecognized command: splitVector")) {
                    ok = false;
                }
                throw e;
            }
            if (data != null) {
                if (data.containsField("$err")) {
                    throw new SplitFailedException("Error calculating splits: " + data);
                }
                if (!data.get("ok").equals(1.0)) {
                    ok = false;
                }
            }
            if (!ok) {
                block28: {
                    CommandResult stats = inputCollection.getStats();
                    if (stats.containsField("primary")) {
                        DBCursor shards = inputCollection.getDB().getSisterDB("config").getCollection("shards").find(new BasicDBObject("_id", stats.getString("primary")));
                        try {
                            if (!shards.hasNext()) break block28;
                            DBObject shard = shards.next();
                            String host = ((String)shard.get("host")).replace(shard.get("_id") + "/", "");
                            MongoClientURI shardHost = authURI != null ? new MongoClientURIBuilder(authURI).host(host).build() : new MongoClientURIBuilder(inputURI).host(host).build();
                            MongoClient shardClient = null;
                            try {
                                shardClient = new MongoClient(shardHost);
                                data = shardClient.getDB(shardHost.getDatabase()).command(cmd, ReadPreference.primary());
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (shardClient != null) {
                                    shardClient.close();
                                }
                            }
                        }
                        finally {
                            shards.close();
                        }
                    }
                }
                if (data != null && !data.get("ok").equals(1.0)) {
                    throw new SplitFailedException("Unable to calculate input splits: " + data.get("errmsg"));
                }
            }
            if ((splitData = (BasicDBList)data.get("splitKeys")).size() == 0) {
                LOG.warn((Object)"WARNING: No Input Splits were calculated by the split code. Proceeding with a *single* split. Data may be too small, try lowering 'mongo.input.split_size' if this is undesirable.");
            }
            BasicDBObject lastKey = null;
            if (!splitKeyMin.toMap().isEmpty()) {
                lastKey = new BasicDBObject(splitKeyMin.toMap());
            }
            for (Object aSplitData : splitData) {
                BasicDBObject currentKey = (BasicDBObject)aSplitData;
                returnVal.add(this.createSplitFromBounds(lastKey, currentKey));
                lastKey = currentKey;
            }
            BasicDBObject maxKey = null;
            if (!splitKeyMax.toMap().isEmpty()) {
                maxKey = new BasicDBObject(splitKeyMax.toMap());
            }
            MongoInputSplit lastSplit = this.createSplitFromBounds(lastKey, maxKey);
            returnVal.add(lastSplit);
        }
        finally {
            if (inputCollection != null) {
                MongoConfigUtil.close(inputCollection.getDB().getMongo());
            }
        }
        if (MongoConfigUtil.isFilterEmptySplitsEnabled(this.getConfiguration())) {
            return StandaloneMongoSplitter.filterEmptySplits(returnVal);
        }
        return returnVal;
    }
}

