/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.io.Bits;

public class BSONLoader
implements Iterable<BSONObject>,
Iterator<BSONObject> {
    private static final Log LOG = LogFactory.getLog(BSONLoader.class);
    private final BSONDecoder decoder = new BasicBSONDecoder();
    private final BSONCallback callback = new BasicBSONCallback();
    private volatile byte[] nextHdr;
    private volatile int nextLen;
    private AtomicBoolean hasMore = new AtomicBoolean(true);
    private final DataInputStream input;

    public BSONLoader(InputStream input) {
        this.input = new DataInputStream(input);
    }

    @Override
    public Iterator<BSONObject> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkHeader();
        return this.hasMore.get();
    }

    private synchronized void checkHeader() {
        byte[] l = new byte[4];
        try {
            this.input.readFully(l);
            this.nextLen = Bits.readInt(l);
            this.nextHdr = l;
            this.hasMore.set(true);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to get next header: " + e), (Throwable)e);
            }
            this.hasMore.set(false);
            try {
                this.input.close();
            }
            catch (IOException e1) {
                LOG.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @Override
    public BSONObject next() {
        try {
            byte[] data = new byte[this.nextLen + 4];
            System.arraycopy(this.nextHdr, 0, data, 0, 4);
            this.input.readFully(data, 4, this.nextLen - 4);
            this.decoder.decode(data, this.callback);
            return (BSONObject)this.callback.get();
        }
        catch (IOException e) {
            LOG.info((Object)("No Length Header available." + e));
            this.hasMore.set(false);
            try {
                this.input.close();
            }
            catch (IOException e1) {
                LOG.warn((Object)e1.getMessage(), (Throwable)e1);
            }
            throw new NoSuchElementException("Iteration completed.");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

