/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.hadoop.util.MongoConfigUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;

public final class CompatUtils {
    private CompatUtils() {
    }

    public static TaskAttemptContext getTaskAttemptContext(org.apache.hadoop.mapreduce.TaskAttemptContext context) {
        return (TaskAttemptContext)Proxy.newProxyInstance(TaskAttemptContext.class.getClassLoader(), new Class[]{CompatProxy.class, TaskAttemptContext.class}, (InvocationHandler)new CompatibleInvocationHandler(context));
    }

    public static TaskAttemptContext getTaskAttemptContext(final Configuration conf, final String taskID) {
        return new TaskAttemptContext(){

            @Override
            public Configuration getConfiguration() {
                return conf;
            }

            @Override
            public TaskAttemptID getTaskAttemptID() {
                return TaskAttemptID.forName((String)taskID);
            }

            public void progress() {
            }
        };
    }

    public static <U> Class<? extends U> loadClass(Configuration conf, String className, Class<U> xface) {
        try {
            Class<U> klass = MongoConfigUtil.getClassByName(conf, className, xface);
            conf.setClass(className, klass, xface);
            return klass;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isInstance(Object test, String className, Configuration conf, Class<?> xface) {
        Class<?> testAgainst = CompatUtils.loadClass(conf, className, xface);
        return testAgainst != null && test.getClass().isInstance(testAgainst);
    }

    public static Object invokeMethod(Class<?> xface, Object invokee, String methodName, Object[] parameters, Class[] parameterTypes) {
        Object asSubclass = xface.cast(invokee);
        try {
            Method method = asSubclass.getClass().getMethod(methodName, parameterTypes);
            return method.invoke(invokee, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static class CompatibleInvocationHandler
    implements InvocationHandler {
        private final Object target;

        public CompatibleInvocationHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
            return m.invoke(this.target, args);
        }
    }

    private static interface CompatProxy {
    }

    public static interface TaskAttemptContext
    extends Progressable {
        public Configuration getConfiguration();

        public TaskAttemptID getTaskAttemptID();
    }
}

