/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;

public final class MapredMongoConfigUtil {
    @Deprecated
    public static final String JOB_VERBOSE = "mongo.job.verbose";
    @Deprecated
    public static final String JOB_BACKGROUND = "mongo.job.background";
    @Deprecated
    public static final String JOB_MAPPER = "mongo.job.mapper";
    @Deprecated
    public static final String JOB_COMBINER = "mongo.job.combiner";
    @Deprecated
    public static final String JOB_PARTITIONER = "mongo.job.partitioner";
    @Deprecated
    public static final String JOB_REDUCER = "mongo.job.reducer";
    @Deprecated
    public static final String JOB_SORT_COMPARATOR = "mongo.job.sort_comparator";
    @Deprecated
    public static final String JOB_MAPPER_OUTPUT_KEY = "mongo.job.mapper.output.key";
    @Deprecated
    public static final String JOB_MAPPER_OUTPUT_VALUE = "mongo.job.mapper.output.value";
    @Deprecated
    public static final String JOB_INPUT_FORMAT = "mongo.job.input.format";
    @Deprecated
    public static final String JOB_OUTPUT_FORMAT = "mongo.job.output.format";
    @Deprecated
    public static final String JOB_OUTPUT_KEY = "mongo.job.output.key";
    @Deprecated
    public static final String JOB_OUTPUT_VALUE = "mongo.job.output.value";
    @Deprecated
    public static final String INPUT_URI = "mongo.input.uri";
    @Deprecated
    public static final String INPUT_MONGOS_HOSTS = "mongo.input.mongos_hosts";
    @Deprecated
    public static final String OUTPUT_URI = "mongo.output.uri";
    @Deprecated
    public static final String MONGO_SPLITTER_CLASS = "mongo.splitter.class";
    @Deprecated
    public static final String INPUT_KEY = "mongo.input.key";
    @Deprecated
    public static final String INPUT_NOTIMEOUT = "mongo.input.notimeout";
    @Deprecated
    public static final String INPUT_QUERY = "mongo.input.query";
    @Deprecated
    public static final String INPUT_FIELDS = "mongo.input.fields";
    @Deprecated
    public static final String INPUT_SORT = "mongo.input.sort";
    @Deprecated
    public static final String INPUT_LIMIT = "mongo.input.limit";
    @Deprecated
    public static final String INPUT_SKIP = "mongo.input.skip";
    @Deprecated
    public static final String INPUT_LAZY_BSON = "mongo.input.lazy_bson";
    @Deprecated
    public static final String BSON_SPLITS_PATH = "bson.split.splits_path";
    @Deprecated
    public static final String BSON_READ_SPLITS = "bson.split.read_splits";
    @Deprecated
    public static final String BSON_WRITE_SPLITS = "bson.split.write_splits";
    @Deprecated
    public static final String BSON_OUTPUT_BUILDSPLITS = "bson.output.build_splits";
    @Deprecated
    public static final String BSON_PATHFILTER = "bson.pathfilter.class";
    @Deprecated
    public static final String AUTH_URI = "mongo.auth.uri";
    @Deprecated
    public static final String INPUT_SPLIT_SIZE = "mongo.input.split_size";
    @Deprecated
    public static final int DEFAULT_SPLIT_SIZE = 8;
    @Deprecated
    public static final String INPUT_SPLIT_KEY_PATTERN = "mongo.input.split.split_key_pattern";
    @Deprecated
    public static final String CREATE_INPUT_SPLITS = "mongo.input.split.create_input_splits";
    @Deprecated
    public static final String SPLITS_USE_SHARDS = "mongo.input.split.read_from_shards";
    @Deprecated
    public static final String SPLITS_USE_CHUNKS = "mongo.input.split.read_shard_chunks";
    @Deprecated
    public static final String SPLITS_SLAVE_OK = "mongo.input.split.allow_read_from_secondaries";
    @Deprecated
    public static final String SPLITS_USE_RANGEQUERY = "mongo.input.split.use_range_queries";

    private MapredMongoConfigUtil() {
    }

    public static boolean isJobVerbose(Configuration conf) {
        return MongoConfigUtil.isJobVerbose(conf);
    }

    public static void setJobVerbose(Configuration conf, boolean val) {
        MongoConfigUtil.setJobVerbose(conf, val);
    }

    public static boolean isJobBackground(Configuration conf) {
        return MongoConfigUtil.isJobBackground(conf);
    }

    public static void setJobBackground(Configuration conf, boolean val) {
        MongoConfigUtil.setJobBackground(conf, val);
    }

    public static Class<? extends Mapper> getMapper(Configuration conf) {
        return conf.getClass(JOB_MAPPER, null, Mapper.class);
    }

    public static void setMapper(Configuration conf, Class<? extends Mapper> val) {
        conf.setClass(JOB_MAPPER, val, Mapper.class);
    }

    public static Class<?> getMapperOutputKey(Configuration conf) {
        return MongoConfigUtil.getMapperOutputKey(conf);
    }

    public static void setMapperOutputKey(Configuration conf, Class<?> val) {
        MongoConfigUtil.setMapperOutputKey(conf, val);
    }

    public static Class<?> getMapperOutputValue(Configuration conf) {
        return MongoConfigUtil.getMapperOutputValue(conf);
    }

    public static void setMapperOutputValue(Configuration conf, Class<?> val) {
        MongoConfigUtil.setMapperOutputValue(conf, val);
    }

    public static Class<? extends Reducer> getCombiner(Configuration conf) {
        return conf.getClass(JOB_COMBINER, null, Reducer.class);
    }

    public static void setCombiner(Configuration conf, Class<? extends Reducer> val) {
        conf.setClass(JOB_COMBINER, val, Reducer.class);
    }

    public static Class<? extends Reducer> getReducer(Configuration conf) {
        return conf.getClass(JOB_REDUCER, null, Reducer.class);
    }

    public static void setReducer(Configuration conf, Class<? extends Reducer> val) {
        conf.setClass(JOB_REDUCER, val, Reducer.class);
    }

    public static Class<? extends Partitioner> getPartitioner(Configuration conf) {
        return conf.getClass(JOB_PARTITIONER, null, Partitioner.class);
    }

    public static void setPartitioner(Configuration conf, Class<? extends Partitioner> val) {
        conf.setClass(JOB_PARTITIONER, val, Partitioner.class);
    }

    public static Class<? extends RawComparator> getSortComparator(Configuration conf) {
        return MongoConfigUtil.getSortComparator(conf);
    }

    public static void setSortComparator(Configuration conf, Class<? extends RawComparator> val) {
        MongoConfigUtil.setSortComparator(conf, val);
    }

    public static Class<? extends OutputFormat> getOutputFormat(Configuration conf) {
        return conf.getClass(JOB_OUTPUT_FORMAT, null, OutputFormat.class);
    }

    public static void setOutputFormat(Configuration conf, Class<? extends OutputFormat> val) {
        conf.setClass(JOB_OUTPUT_FORMAT, val, OutputFormat.class);
    }

    public static Class<?> getOutputKey(Configuration conf) {
        return MongoConfigUtil.getOutputKey(conf);
    }

    public static void setOutputKey(Configuration conf, Class<?> val) {
        MongoConfigUtil.setOutputKey(conf, val);
    }

    public static Class<?> getOutputValue(Configuration conf) {
        return MongoConfigUtil.getOutputValue(conf);
    }

    public static void setOutputValue(Configuration conf, Class<?> val) {
        MongoConfigUtil.setOutputValue(conf, val);
    }

    public static Class<? extends InputFormat> getInputFormat(Configuration conf) {
        return conf.getClass(JOB_INPUT_FORMAT, null, InputFormat.class);
    }

    public static void setInputFormat(Configuration conf, Class<? extends InputFormat> val) {
        conf.setClass(JOB_INPUT_FORMAT, val, InputFormat.class);
    }

    public static List<MongoClientURI> getMongoURIs(Configuration conf, String key) {
        return MongoConfigUtil.getMongoURIs(conf, key);
    }

    @Deprecated
    public static MongoURI getMongoURI(Configuration conf, String key) {
        return MongoConfigUtil.getMongoURI(conf, key);
    }

    public static MongoClientURI getMongoClientURI(Configuration conf, String key) {
        return MongoConfigUtil.getMongoClientURI(conf, key);
    }

    public static MongoClientURI getInputURI(Configuration conf) {
        return MongoConfigUtil.getInputURI(conf);
    }

    public static MongoClientURI getAuthURI(Configuration conf) {
        return MongoConfigUtil.getAuthURI(conf);
    }

    public static List<DBCollection> getCollections(List<MongoClientURI> uris, MongoClientURI authURI) {
        return MongoConfigUtil.getCollections(uris, authURI);
    }

    @Deprecated
    public static DBCollection getCollection(MongoURI uri) {
        return MongoConfigUtil.getCollection(uri);
    }

    public static DBCollection getCollection(MongoClientURI uri) {
        return MongoConfigUtil.getCollection(uri);
    }

    @Deprecated
    public static DBCollection getCollectionWithAuth(MongoURI uri, MongoURI authURI) {
        return MongoConfigUtil.getCollectionWithAuth(uri, authURI);
    }

    public static DBCollection getCollectionWithAuth(MongoClientURI uri, MongoClientURI authURI) {
        return MongoConfigUtil.getCollectionWithAuth(uri, authURI);
    }

    public static DBCollection getOutputCollection(Configuration conf) {
        return MongoConfigUtil.getOutputCollection(conf);
    }

    public static DBCollection getInputCollection(Configuration conf) {
        return MongoConfigUtil.getInputCollection(conf);
    }

    @Deprecated
    public static void setMongoURI(Configuration conf, String key, MongoURI value) {
        MongoConfigUtil.setMongoURI(conf, key, value);
    }

    public static void setMongoURI(Configuration conf, String key, MongoClientURI value) {
        MongoConfigUtil.setMongoURI(conf, key, value);
    }

    public static void setMongoURIString(Configuration conf, String key, String value) {
        MongoConfigUtil.setMongoURIString(conf, key, value);
    }

    public static void setAuthURI(Configuration conf, String uri) {
        MongoConfigUtil.setAuthURI(conf, uri);
    }

    public static void setInputURI(Configuration conf, String uri) {
        MongoConfigUtil.setInputURI(conf, uri);
    }

    @Deprecated
    public static void setInputURI(Configuration conf, MongoURI uri) {
        MongoConfigUtil.setInputURI(conf, uri);
    }

    public static void setInputURI(Configuration conf, MongoClientURI uri) {
        MongoConfigUtil.setInputURI(conf, uri);
    }

    public static List<MongoClientURI> getOutputURIs(Configuration conf) {
        return MongoConfigUtil.getOutputURIs(conf);
    }

    public static MongoClientURI getOutputURI(Configuration conf) {
        return MongoConfigUtil.getOutputURI(conf);
    }

    public static void setOutputURI(Configuration conf, String uri) {
        MongoConfigUtil.setOutputURI(conf, uri);
    }

    @Deprecated
    public static void setOutputURI(Configuration conf, MongoURI uri) {
        MongoConfigUtil.setOutputURI(conf, uri);
    }

    public static void setOutputURI(Configuration conf, MongoClientURI uri) {
        MongoConfigUtil.setOutputURI(conf, uri);
    }

    public static void setJSON(Configuration conf, String key, String value) {
        MongoConfigUtil.setJSON(conf, key, value);
    }

    public static DBObject getDBObject(Configuration conf, String key) {
        return MongoConfigUtil.getDBObject(conf, key);
    }

    public static void setDBObject(Configuration conf, String key, DBObject value) {
        MongoConfigUtil.setDBObject(conf, key, value);
    }

    public static void setQuery(Configuration conf, String query) {
        MongoConfigUtil.setQuery(conf, query);
    }

    public static void setQuery(Configuration conf, DBObject query) {
        MongoConfigUtil.setQuery(conf, query);
    }

    public static DBObject getQuery(Configuration conf) {
        return MongoConfigUtil.getQuery(conf);
    }

    public static void setFields(Configuration conf, String fields) {
        MongoConfigUtil.setFields(conf, fields);
    }

    public static void setFields(Configuration conf, DBObject fields) {
        MongoConfigUtil.setFields(conf, fields);
    }

    public static DBObject getFields(Configuration conf) {
        return MongoConfigUtil.getFields(conf);
    }

    public static void setSort(Configuration conf, String sort) {
        MongoConfigUtil.setSort(conf, sort);
    }

    public static void setSort(Configuration conf, DBObject sort) {
        MongoConfigUtil.setSort(conf, sort);
    }

    public static DBObject getSort(Configuration conf) {
        return MongoConfigUtil.getSort(conf);
    }

    public static int getLimit(Configuration conf) {
        return MongoConfigUtil.getLimit(conf);
    }

    public static void setLimit(Configuration conf, int limit) {
        MongoConfigUtil.setLimit(conf, limit);
    }

    public static int getSkip(Configuration conf) {
        return MongoConfigUtil.getSkip(conf);
    }

    public static void setSkip(Configuration conf, int skip) {
        MongoConfigUtil.setSkip(conf, skip);
    }

    public static boolean getLazyBSON(Configuration conf) {
        return MongoConfigUtil.getLazyBSON(conf);
    }

    public static void setLazyBSON(Configuration conf, boolean lazy) {
        MongoConfigUtil.setLazyBSON(conf, lazy);
    }

    public static int getSplitSize(Configuration conf) {
        return MongoConfigUtil.getSplitSize(conf);
    }

    public static void setSplitSize(Configuration conf, int value) {
        MongoConfigUtil.setSplitSize(conf, value);
    }

    public static boolean isRangeQueryEnabled(Configuration conf) {
        return conf.getBoolean(SPLITS_USE_RANGEQUERY, false);
    }

    public static void setRangeQueryEnabled(Configuration conf, boolean value) {
        MongoConfigUtil.setRangeQueryEnabled(conf, value);
    }

    public static boolean canReadSplitsFromShards(Configuration conf) {
        return MongoConfigUtil.canReadSplitsFromShards(conf);
    }

    public static void setReadSplitsFromShards(Configuration conf, boolean value) {
        MongoConfigUtil.setReadSplitsFromShards(conf, value);
    }

    public static boolean isShardChunkedSplittingEnabled(Configuration conf) {
        return MongoConfigUtil.isShardChunkedSplittingEnabled(conf);
    }

    public static void setShardChunkSplittingEnabled(Configuration conf, boolean value) {
        MongoConfigUtil.setShardChunkSplittingEnabled(conf, value);
    }

    public static boolean canReadSplitsFromSecondary(Configuration conf) {
        return MongoConfigUtil.canReadSplitsFromSecondary(conf);
    }

    public static void setReadSplitsFromSecondary(Configuration conf, boolean value) {
        MongoConfigUtil.setReadSplitsFromSecondary(conf, value);
    }

    public static boolean createInputSplits(Configuration conf) {
        return MongoConfigUtil.createInputSplits(conf);
    }

    public static void setCreateInputSplits(Configuration conf, boolean value) {
        MongoConfigUtil.setCreateInputSplits(conf, value);
    }

    public static void setInputSplitKeyPattern(Configuration conf, String pattern) {
        MongoConfigUtil.setInputSplitKeyPattern(conf, pattern);
    }

    public static void setInputSplitKey(Configuration conf, DBObject key) {
        MongoConfigUtil.setInputSplitKey(conf, key);
    }

    public static String getInputSplitKeyPattern(Configuration conf) {
        return MongoConfigUtil.getInputSplitKeyPattern(conf);
    }

    public static DBObject getInputSplitKey(Configuration conf) {
        return MongoConfigUtil.getInputSplitKey(conf);
    }

    public static void setInputKey(Configuration conf, String fieldName) {
        MongoConfigUtil.setInputKey(conf, fieldName);
    }

    public static String getInputKey(Configuration conf) {
        return MongoConfigUtil.getInputKey(conf);
    }

    public static void setNoTimeout(Configuration conf, boolean value) {
        MongoConfigUtil.setNoTimeout(conf, value);
    }

    public static boolean isNoTimeout(Configuration conf) {
        return MongoConfigUtil.isNoTimeout(conf);
    }

    public static boolean getBSONReadSplits(Configuration conf) {
        return MongoConfigUtil.getBSONReadSplits(conf);
    }

    public static void setBSONReadSplits(Configuration conf, boolean val) {
        MongoConfigUtil.setBSONReadSplits(conf, val);
    }

    public static boolean getBSONWriteSplits(Configuration conf) {
        return MongoConfigUtil.getBSONWriteSplits(conf);
    }

    public static void setBSONWriteSplits(Configuration conf, boolean val) {
        MongoConfigUtil.setBSONWriteSplits(conf, val);
    }

    public static boolean getBSONOutputBuildSplits(Configuration conf) {
        return MongoConfigUtil.getBSONOutputBuildSplits(conf);
    }

    public static void setBSONOutputBuildSplits(Configuration conf, boolean val) {
        MongoConfigUtil.setBSONOutputBuildSplits(conf, val);
    }

    public static String getBSONSplitsPath(Configuration conf) {
        return MongoConfigUtil.getBSONSplitsPath(conf);
    }

    public static void setBSONSplitsPath(Configuration conf, String path) {
        MongoConfigUtil.setBSONSplitsPath(conf, path);
    }

    public static void setBSONPathFilter(Configuration conf, Class<? extends PathFilter> val) {
        MongoConfigUtil.setBSONPathFilter(conf, val);
    }

    public static Class<?> getBSONPathFilter(Configuration conf) {
        return MongoConfigUtil.getBSONPathFilter(conf);
    }

    public static Class<? extends MongoSplitter> getSplitterClass(Configuration conf) {
        return MongoConfigUtil.getSplitterClass(conf);
    }

    public static void setSplitterClass(Configuration conf, Class<? extends MongoSplitter> val) {
        MongoConfigUtil.setSplitterClass(conf, val);
    }

    public static List<String> getInputMongosHosts(Configuration conf) {
        return MongoConfigUtil.getInputMongosHosts(conf);
    }

    public static void setInputMongosHosts(Configuration conf, List<String> hostnames) {
        MongoConfigUtil.setInputMongosHosts(conf, hostnames);
    }

    public static <U> Class<? extends U> getClassByName(Configuration conf, String className, Class<U> xface) {
        return MongoConfigUtil.getClassByName(conf, className, xface);
    }

    public static Configuration buildConfiguration(Map<String, Object> data) {
        return MongoConfigUtil.buildConfiguration(data);
    }
}

