/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongoClientURIBuilder {
    private MongoClientOptions options;
    private MongoCredential credentials;
    private final List<String> hosts = new ArrayList<String>();
    private String database;
    private String collection;
    private String userName;
    private String password;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public MongoClientURIBuilder() {
    }

    public MongoClientURIBuilder(MongoClientURI mongoClientURI) {
        List<String> list = mongoClientURI.getHosts();
        for (String s : list) {
            this.host(s);
        }
        this.database = mongoClientURI.getDatabase();
        this.collection = mongoClientURI.getCollection();
        this.userName = mongoClientURI.getUsername();
        if (mongoClientURI.getPassword() != null) {
            this.password = new String(mongoClientURI.getPassword());
        }
        this.options = mongoClientURI.getOptions();
        String uri = mongoClientURI.getURI();
        if (uri.contains("?")) {
            String[] pairs;
            String query = uri.substring(uri.indexOf(63) + 1);
            for (String pair : pairs = query.split("&")) {
                String[] split = pair.split("=");
                this.param(split[0], split[1]);
            }
        }
    }

    public MongoClientURIBuilder host(String host) {
        return this.host(host, null);
    }

    public MongoClientURIBuilder host(String newHost, Integer newPort) {
        this.hosts.clear();
        this.addHost(newHost, newPort);
        return this;
    }

    public void addHost(String newHost, Integer newPort) {
        if (newHost.contains(":") && newPort == null) {
            this.hosts.add(newHost);
        } else {
            String host = newHost.isEmpty() ? "localhost" : newHost;
            Integer port = newPort == null ? 27017 : newPort;
            if (host.contains(":")) {
                host = host.substring(0, host.indexOf(58));
            }
            this.hosts.add(String.format("%s:%d", host, port));
        }
    }

    public MongoClientURIBuilder port(Integer port) {
        if (this.hosts.size() == 0) {
            this.host("localhost", port);
        } else {
            this.host(this.hosts.get(0), port);
        }
        return this;
    }

    public MongoClientURIBuilder collection(String database, String collection) {
        this.database = database;
        this.collection = collection;
        return this;
    }

    public MongoClientURIBuilder auth(String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.params.put("authSource", "admin");
        return this;
    }

    public MongoClientURIBuilder options(MongoClientOptions options) {
        this.options = options;
        return this;
    }

    public MongoClientURIBuilder param(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public MongoClientURI build() {
        StringBuilder uri = new StringBuilder(String.format("mongodb://", new Object[0]));
        if (this.userName != null) {
            uri.append(String.format("%s:%s@", this.userName, this.password));
        }
        if (this.hosts.isEmpty()) {
            uri.append("localhost");
        } else {
            for (int i = 0; i < this.hosts.size(); ++i) {
                String host = this.hosts.get(i);
                if (i != 0) {
                    uri.append(",");
                }
                uri.append(host);
            }
        }
        if (this.database != null) {
            uri.append(String.format("/%s.%s", this.database, this.collection));
        }
        if (!this.params.isEmpty()) {
            boolean paramAdded = false;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                uri.append(paramAdded ? "&" : "?");
                paramAdded = true;
                uri.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return new MongoClientURI(uri.toString());
    }

    public MongoClientURIBuilder readPreference(ReadPreference readPreference) {
        if (!readPreference.equals(ReadPreference.primary())) {
            this.params.put("readPreference", readPreference.toString());
        } else {
            this.params.remove("readPreference");
        }
        return this;
    }
}

