/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;

public final class MongoConfigUtil {
    private static final Log LOG = LogFactory.getLog(MongoConfigUtil.class);
    public static final String JOB_VERBOSE = "mongo.job.verbose";
    public static final String JOB_BACKGROUND = "mongo.job.background";
    public static final String JOB_MAPPER = "mongo.job.mapper";
    public static final String JOB_COMBINER = "mongo.job.combiner";
    public static final String JOB_PARTITIONER = "mongo.job.partitioner";
    public static final String JOB_REDUCER = "mongo.job.reducer";
    public static final String JOB_SORT_COMPARATOR = "mongo.job.sort_comparator";
    public static final String JOB_MAPPER_OUTPUT_KEY = "mongo.job.mapper.output.key";
    public static final String JOB_MAPPER_OUTPUT_VALUE = "mongo.job.mapper.output.value";
    public static final String JOB_INPUT_FORMAT = "mongo.job.input.format";
    public static final String JOB_OUTPUT_FORMAT = "mongo.job.output.format";
    public static final String JOB_OUTPUT_KEY = "mongo.job.output.key";
    public static final String JOB_OUTPUT_VALUE = "mongo.job.output.value";
    public static final String INPUT_URI = "mongo.input.uri";
    public static final String INPUT_MONGOS_HOSTS = "mongo.input.mongos_hosts";
    public static final String OUTPUT_URI = "mongo.output.uri";
    public static final String OUTPUT_BATCH_SIZE = "mongo.output.batch.size";
    public static final String OUTPUT_BULK_ORDERED = "mongo.output.bulk.ordered";
    public static final String MONGO_SPLITTER_CLASS = "mongo.splitter.class";
    public static final String INPUT_KEY = "mongo.input.key";
    public static final String INPUT_NOTIMEOUT = "mongo.input.notimeout";
    public static final String INPUT_QUERY = "mongo.input.query";
    public static final String INPUT_FIELDS = "mongo.input.fields";
    public static final String INPUT_SORT = "mongo.input.sort";
    public static final String INPUT_LIMIT = "mongo.input.limit";
    public static final String INPUT_SKIP = "mongo.input.skip";
    public static final String INPUT_LAZY_BSON = "mongo.input.lazy_bson";
    public static final String BSON_SPLITS_PATH = "bson.split.splits_path";
    public static final String BSON_READ_SPLITS = "bson.split.read_splits";
    public static final String BSON_WRITE_SPLITS = "bson.split.write_splits";
    public static final String BSON_OUTPUT_BUILDSPLITS = "bson.output.build_splits";
    public static final String BSON_PATHFILTER = "bson.pathfilter.class";
    public static final String GRIDFS_DELIMITER_PATTERN = "mongo.gridfs.delimiter.pattern";
    public static final String GRIDFS_DEFAULT_DELIMITER = "(\n|\r\n)";
    public static final String GRIDFS_WHOLE_FILE_SPLIT = "mongo.gridfs.whole_file";
    public static final String GRIDFS_READ_BINARY = "mongo.gridfs.read_binary";
    public static final String AUTH_URI = "mongo.auth.uri";
    public static final String INPUT_SPLIT_SIZE = "mongo.input.split_size";
    public static final int DEFAULT_SPLIT_SIZE = 8;
    public static final String ENABLE_FILTER_EMPTY_SPLITS = "mongo.input.splits.filter_empty";
    public static final String INPUT_SPLIT_MIN_DOCS = "mongo.input.splits.min_docs";
    public static final int DEFAULT_INPUT_SPLIT_MIN_DOCS = 1000;
    public static final String INPUT_SPLIT_KEY_PATTERN = "mongo.input.split.split_key_pattern";
    public static final String INPUT_SPLIT_KEY_MIN = "mongo.input.split.split_key_min";
    public static final String INPUT_SPLIT_KEY_MAX = "mongo.input.split.split_key_max";
    public static final String CREATE_INPUT_SPLITS = "mongo.input.split.create_input_splits";
    public static final String SPLITS_USE_SHARDS = "mongo.input.split.read_from_shards";
    public static final String SPLITS_USE_CHUNKS = "mongo.input.split.read_shard_chunks";
    public static final String SPLITS_SLAVE_OK = "mongo.input.split.allow_read_from_secondaries";
    public static final String SPLITS_USE_RANGEQUERY = "mongo.input.split.use_range_queries";
    private static final ThreadLocal<Map<MongoClientURI, MongoClient>> CLIENTS = new ThreadLocal<Map<MongoClientURI, MongoClient>>(){

        @Override
        public Map<MongoClientURI, MongoClient> initialValue() {
            return new HashMap<MongoClientURI, MongoClient>();
        }
    };
    private static final ThreadLocal<Map<MongoClient, MongoClientURI>> URI_MAP = new ThreadLocal<Map<MongoClient, MongoClientURI>>(){

        @Override
        public Map<MongoClient, MongoClientURI> initialValue() {
            return new HashMap<MongoClient, MongoClientURI>();
        }
    };

    private MongoConfigUtil() {
    }

    public static boolean isJobVerbose(Configuration conf) {
        return conf.getBoolean(JOB_VERBOSE, false);
    }

    public static void setJobVerbose(Configuration conf, boolean val) {
        conf.setBoolean(JOB_VERBOSE, val);
    }

    public static boolean isJobBackground(Configuration conf) {
        return conf.getBoolean(JOB_BACKGROUND, false);
    }

    public static void setJobBackground(Configuration conf, boolean val) {
        conf.setBoolean(JOB_BACKGROUND, val);
    }

    public static Class<? extends Mapper> getMapper(Configuration conf) {
        return conf.getClass(JOB_MAPPER, null, Mapper.class);
    }

    public static void setMapper(Configuration conf, Class<? extends Mapper> val) {
        conf.setClass(JOB_MAPPER, val, Mapper.class);
    }

    public static Class<?> getMapperOutputKey(Configuration conf) {
        return conf.getClass(JOB_MAPPER_OUTPUT_KEY, null);
    }

    public static void setMapperOutputKey(Configuration conf, Class<?> val) {
        conf.setClass(JOB_MAPPER_OUTPUT_KEY, val, Object.class);
    }

    public static Class<?> getMapperOutputValue(Configuration conf) {
        return conf.getClass(JOB_MAPPER_OUTPUT_VALUE, null);
    }

    public static void setMapperOutputValue(Configuration conf, Class<?> val) {
        conf.setClass(JOB_MAPPER_OUTPUT_VALUE, val, Object.class);
    }

    public static Class<? extends Reducer> getCombiner(Configuration conf) {
        return conf.getClass(JOB_COMBINER, null, Reducer.class);
    }

    public static void setCombiner(Configuration conf, Class<? extends Reducer> val) {
        conf.setClass(JOB_COMBINER, val, Reducer.class);
    }

    public static Class<? extends Reducer> getReducer(Configuration conf) {
        return conf.getClass(JOB_REDUCER, null, Reducer.class);
    }

    public static void setReducer(Configuration conf, Class<? extends Reducer> val) {
        conf.setClass(JOB_REDUCER, val, Reducer.class);
    }

    public static Class<? extends Partitioner> getPartitioner(Configuration conf) {
        return conf.getClass(JOB_PARTITIONER, null, Partitioner.class);
    }

    public static void setPartitioner(Configuration conf, Class<? extends Partitioner> val) {
        conf.setClass(JOB_PARTITIONER, val, Partitioner.class);
    }

    public static Class<? extends RawComparator> getSortComparator(Configuration conf) {
        return conf.getClass(JOB_SORT_COMPARATOR, null, RawComparator.class);
    }

    public static void setSortComparator(Configuration conf, Class<? extends RawComparator> val) {
        conf.setClass(JOB_SORT_COMPARATOR, val, RawComparator.class);
    }

    public static Class<? extends OutputFormat> getOutputFormat(Configuration conf) {
        return conf.getClass(JOB_OUTPUT_FORMAT, null, OutputFormat.class);
    }

    public static void setOutputFormat(Configuration conf, Class<? extends OutputFormat> val) {
        conf.setClass(JOB_OUTPUT_FORMAT, val, OutputFormat.class);
    }

    public static Class<?> getOutputKey(Configuration conf) {
        return conf.getClass(JOB_OUTPUT_KEY, null);
    }

    public static void setOutputKey(Configuration conf, Class<?> val) {
        conf.setClass(JOB_OUTPUT_KEY, val, Object.class);
    }

    public static Class<?> getOutputValue(Configuration conf) {
        return conf.getClass(JOB_OUTPUT_VALUE, null);
    }

    public static void setOutputValue(Configuration conf, Class<?> val) {
        conf.setClass(JOB_OUTPUT_VALUE, val, Object.class);
    }

    public static Class<? extends InputFormat> getInputFormat(Configuration conf) {
        return conf.getClass(JOB_INPUT_FORMAT, null, InputFormat.class);
    }

    public static void setInputFormat(Configuration conf, Class<? extends InputFormat> val) {
        conf.setClass(JOB_INPUT_FORMAT, val, InputFormat.class);
    }

    public static List<MongoClientURI> getMongoURIs(Configuration conf, String key) {
        String raw = conf.get(key);
        LinkedList<MongoClientURI> result = new LinkedList<MongoClientURI>();
        if (raw != null && !raw.trim().isEmpty()) {
            for (String connectionString : raw.split("mongodb://")) {
                if ((connectionString = StringUtils.strip((String)connectionString, (String)", ")).isEmpty()) continue;
                result.add(new MongoClientURI("mongodb://" + connectionString));
            }
        }
        return result;
    }

    @Deprecated
    public static MongoURI getMongoURI(Configuration conf, String key) {
        String raw = conf.get(key);
        if (raw != null && !raw.trim().isEmpty()) {
            return new MongoURI(raw);
        }
        return null;
    }

    public static MongoClientURI getMongoClientURI(Configuration conf, String key) {
        String raw = conf.get(key);
        return raw != null && !raw.trim().isEmpty() ? new MongoClientURI(raw) : null;
    }

    public static MongoClientURI getInputURI(Configuration conf) {
        return MongoConfigUtil.getMongoClientURI(conf, INPUT_URI);
    }

    public static MongoClientURI getAuthURI(Configuration conf) {
        return MongoConfigUtil.getMongoClientURI(conf, AUTH_URI);
    }

    public static List<DBCollection> getCollections(List<MongoClientURI> uris, MongoClientURI authURI) {
        LinkedList<DBCollection> dbCollections = new LinkedList<DBCollection>();
        for (MongoClientURI uri : uris) {
            if (authURI != null) {
                dbCollections.add(MongoConfigUtil.getCollectionWithAuth(uri, authURI));
                continue;
            }
            dbCollections.add(MongoConfigUtil.getCollection(uri));
        }
        return dbCollections;
    }

    @Deprecated
    public static DBCollection getCollection(MongoURI uri) {
        return MongoConfigUtil.getCollection(new MongoClientURI(uri.toString()));
    }

    public static DBCollection getCollection(MongoClientURI uri) {
        try {
            return MongoConfigUtil.getMongoClient(uri).getDB(uri.getDatabase()).getCollection(uri.getCollection());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't connect and authenticate to get collection", e);
        }
    }

    @Deprecated
    public static DBCollection getCollectionWithAuth(MongoURI uri, MongoURI authURI) {
        return MongoConfigUtil.getCollectionWithAuth(new MongoClientURI(uri.toString()), new MongoClientURI(authURI.toString()));
    }

    public static DBCollection getCollectionWithAuth(MongoClientURI uri, MongoClientURI authURI) {
        if (authURI == null || authURI.getUsername() == null || authURI.getPassword() == null) {
            throw new IllegalArgumentException("auth URI is empty or does not contain a valid username/password combination.");
        }
        try {
            MongoClient mongo = MongoConfigUtil.getMongoClient(authURI);
            DBCollection coll = mongo.getDB(uri.getDatabase()).getCollection(uri.getCollection());
            return coll;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't connect and authenticate to get collection", e);
        }
    }

    public static DBCollection getOutputCollection(Configuration conf) {
        try {
            return MongoConfigUtil.getCollection(MongoConfigUtil.getOutputURI(conf));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to connect to MongoDB Output Collection.", e);
        }
    }

    public static DBCollection getInputCollection(Configuration conf) {
        try {
            return MongoConfigUtil.getCollection(MongoConfigUtil.getInputURI(conf));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to connect to MongoDB Input Collection at '" + MongoConfigUtil.getInputURI(conf) + "'", e);
        }
    }

    @Deprecated
    public static void setMongoURI(Configuration conf, String key, MongoURI value) {
        conf.set(key, value.toString());
    }

    public static void setMongoURI(Configuration conf, String key, MongoClientURI value) {
        conf.set(key, value.toString());
    }

    public static void setMongoURIString(Configuration conf, String key, String value) {
        MongoConfigUtil.setMongoURI(conf, key, new MongoClientURI(value));
    }

    public static void setAuthURI(Configuration conf, String uri) {
        MongoConfigUtil.setMongoURIString(conf, AUTH_URI, uri);
    }

    public static void setInputURI(Configuration conf, String uri) {
        MongoConfigUtil.setMongoURIString(conf, INPUT_URI, uri);
    }

    @Deprecated
    public static void setInputURI(Configuration conf, MongoURI uri) {
        MongoConfigUtil.setMongoURI(conf, INPUT_URI, uri);
    }

    public static void setInputURI(Configuration conf, MongoClientURI uri) {
        MongoConfigUtil.setMongoURI(conf, INPUT_URI, uri);
    }

    public static List<MongoClientURI> getOutputURIs(Configuration conf) {
        return MongoConfigUtil.getMongoURIs(conf, OUTPUT_URI);
    }

    public static MongoClientURI getOutputURI(Configuration conf) {
        return MongoConfigUtil.getMongoClientURI(conf, OUTPUT_URI);
    }

    public static void setOutputURI(Configuration conf, String uri) {
        MongoConfigUtil.setMongoURIString(conf, OUTPUT_URI, uri);
    }

    @Deprecated
    public static void setOutputURI(Configuration conf, MongoURI uri) {
        MongoConfigUtil.setMongoURI(conf, OUTPUT_URI, uri);
    }

    public static void setOutputURI(Configuration conf, MongoClientURI uri) {
        MongoConfigUtil.setMongoURI(conf, OUTPUT_URI, uri);
    }

    public static int getBatchSize(Configuration conf) {
        return conf.getInt(OUTPUT_BATCH_SIZE, 1000);
    }

    public static boolean isBulkOrdered(Configuration conf) {
        return conf.getBoolean(OUTPUT_BULK_ORDERED, true);
    }

    public static void setBulkOrdered(Configuration conf, boolean ordered) {
        conf.setBoolean(OUTPUT_BULK_ORDERED, ordered);
    }

    public static void setBatchSize(Configuration conf, int size) {
        conf.setInt(OUTPUT_BATCH_SIZE, size);
    }

    public static void setJSON(Configuration conf, String key, String value) {
        try {
            Object dbObj = JSON.parse(value);
            MongoConfigUtil.setDBObject(conf, key, (DBObject)dbObj);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot parse JSON...", (Throwable)e);
            throw new IllegalArgumentException("Provided JSON String is not representable/parseable as a DBObject.", e);
        }
    }

    public static DBObject getDBObject(Configuration conf, String key) {
        try {
            String json = conf.get(key);
            DBObject obj = (DBObject)JSON.parse(json);
            if (obj == null) {
                return new BasicDBObject();
            }
            return obj;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Provided JSON String is not representable/parseable as a DBObject.", e);
        }
    }

    public static void setDBObject(Configuration conf, String key, DBObject value) {
        conf.set(key, JSON.serialize(value));
    }

    public static void setQuery(Configuration conf, String query) {
        MongoConfigUtil.setJSON(conf, INPUT_QUERY, query);
    }

    public static void setQuery(Configuration conf, DBObject query) {
        MongoConfigUtil.setDBObject(conf, INPUT_QUERY, query);
    }

    public static DBObject getQuery(Configuration conf) {
        return MongoConfigUtil.getDBObject(conf, INPUT_QUERY);
    }

    public static void setFields(Configuration conf, String fields) {
        MongoConfigUtil.setJSON(conf, INPUT_FIELDS, fields);
    }

    public static void setFields(Configuration conf, DBObject fields) {
        MongoConfigUtil.setDBObject(conf, INPUT_FIELDS, fields);
    }

    public static DBObject getFields(Configuration conf) {
        return MongoConfigUtil.getDBObject(conf, INPUT_FIELDS);
    }

    public static void setSort(Configuration conf, String sort) {
        MongoConfigUtil.setJSON(conf, INPUT_SORT, sort);
    }

    public static void setSort(Configuration conf, DBObject sort) {
        MongoConfigUtil.setDBObject(conf, INPUT_SORT, sort);
    }

    public static DBObject getSort(Configuration conf) {
        return MongoConfigUtil.getDBObject(conf, INPUT_SORT);
    }

    public static int getLimit(Configuration conf) {
        return conf.getInt(INPUT_LIMIT, 0);
    }

    public static void setLimit(Configuration conf, int limit) {
        conf.setInt(INPUT_LIMIT, limit);
    }

    public static int getSkip(Configuration conf) {
        return conf.getInt(INPUT_SKIP, 0);
    }

    public static void setSkip(Configuration conf, int skip) {
        conf.setInt(INPUT_SKIP, skip);
    }

    public static boolean getLazyBSON(Configuration conf) {
        return conf.getBoolean(INPUT_LAZY_BSON, false);
    }

    public static void setLazyBSON(Configuration conf, boolean lazy) {
        conf.setBoolean(INPUT_LAZY_BSON, lazy);
    }

    public static int getSplitSize(Configuration conf) {
        return conf.getInt(INPUT_SPLIT_SIZE, 8);
    }

    public static void setSplitSize(Configuration conf, int value) {
        conf.setInt(INPUT_SPLIT_SIZE, value);
    }

    public static void setEnableFilterEmptySplits(Configuration conf, boolean value) {
        conf.setBoolean(ENABLE_FILTER_EMPTY_SPLITS, value);
    }

    public static boolean isFilterEmptySplitsEnabled(Configuration conf) {
        return conf.getBoolean(ENABLE_FILTER_EMPTY_SPLITS, false);
    }

    public static void setInputSplitMinDocs(Configuration conf, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("mongo.input.splits.min_docs must be greater than 0.");
        }
        conf.setInt(INPUT_SPLIT_MIN_DOCS, value);
    }

    public static int getInputSplitMinDocs(Configuration conf) {
        return conf.getInt(INPUT_SPLIT_MIN_DOCS, 1000);
    }

    public static boolean isRangeQueryEnabled(Configuration conf) {
        return conf.getBoolean(SPLITS_USE_RANGEQUERY, false);
    }

    public static void setRangeQueryEnabled(Configuration conf, boolean value) {
        conf.setBoolean(SPLITS_USE_RANGEQUERY, value);
    }

    public static boolean canReadSplitsFromShards(Configuration conf) {
        return conf.getBoolean(SPLITS_USE_SHARDS, false);
    }

    public static void setReadSplitsFromShards(Configuration conf, boolean value) {
        conf.setBoolean(SPLITS_USE_SHARDS, value);
    }

    public static boolean isShardChunkedSplittingEnabled(Configuration conf) {
        return conf.getBoolean(SPLITS_USE_CHUNKS, true);
    }

    public static int getSamplesPerSplit(Configuration conf) {
        return conf.getInt("mongo.input.splits.samples_per_split", 10);
    }

    public static void setSamplesPerSplit(Configuration conf, int samples) {
        conf.setInt("mongo.input.splits.samples_per_split", samples);
    }

    public static void setShardChunkSplittingEnabled(Configuration conf, boolean value) {
        conf.setBoolean(SPLITS_USE_CHUNKS, value);
    }

    public static boolean canReadSplitsFromSecondary(Configuration conf) {
        return conf.getBoolean(SPLITS_SLAVE_OK, false);
    }

    public static void setReadSplitsFromSecondary(Configuration conf, boolean value) {
        conf.getBoolean(SPLITS_SLAVE_OK, value);
    }

    public static boolean createInputSplits(Configuration conf) {
        return conf.getBoolean(CREATE_INPUT_SPLITS, true);
    }

    public static void setCreateInputSplits(Configuration conf, boolean value) {
        conf.setBoolean(CREATE_INPUT_SPLITS, value);
    }

    public static void setInputSplitKeyPattern(Configuration conf, String pattern) {
        MongoConfigUtil.setJSON(conf, INPUT_SPLIT_KEY_PATTERN, pattern);
    }

    public static void setInputSplitKey(Configuration conf, DBObject key) {
        MongoConfigUtil.setDBObject(conf, INPUT_SPLIT_KEY_PATTERN, key);
    }

    public static String getInputSplitKeyPattern(Configuration conf) {
        return conf.get(INPUT_SPLIT_KEY_PATTERN, "{ \"_id\": 1 }");
    }

    public static DBObject getInputSplitKey(Configuration conf) {
        try {
            String json = MongoConfigUtil.getInputSplitKeyPattern(conf);
            DBObject obj = (DBObject)JSON.parse(json);
            if (obj == null) {
                return new BasicDBObject("_id", (Object)1);
            }
            return obj;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Provided JSON String is not representable/parsable as a DBObject.", e);
        }
    }

    public static DBObject getMinSplitKey(Configuration configuration) {
        return MongoConfigUtil.getDBObject(configuration, INPUT_SPLIT_KEY_MIN);
    }

    public static DBObject getMaxSplitKey(Configuration configuration) {
        return MongoConfigUtil.getDBObject(configuration, INPUT_SPLIT_KEY_MAX);
    }

    public static void setMinSplitKey(Configuration conf, String string) {
        conf.set(INPUT_SPLIT_KEY_MIN, string);
    }

    public static void setMaxSplitKey(Configuration conf, String string) {
        conf.set(INPUT_SPLIT_KEY_MAX, string);
    }

    public static void setInputKey(Configuration conf, String fieldName) {
        conf.set(INPUT_KEY, fieldName);
    }

    public static String getInputKey(Configuration conf) {
        return conf.get(INPUT_KEY, "_id");
    }

    public static String getGridFSDelimiterPattern(Configuration conf) {
        return conf.get(GRIDFS_DELIMITER_PATTERN, GRIDFS_DEFAULT_DELIMITER);
    }

    public static void setGridFSDelimiterPattern(Configuration conf, String pattern) {
        conf.set(GRIDFS_DELIMITER_PATTERN, pattern);
    }

    public static boolean isGridFSWholeFileSplit(Configuration conf) {
        return conf.getBoolean(GRIDFS_WHOLE_FILE_SPLIT, false);
    }

    public static void setGridFSWholeFileSplit(Configuration conf, boolean split) {
        conf.setBoolean(GRIDFS_WHOLE_FILE_SPLIT, split);
    }

    public static boolean isGridFSReadBinary(Configuration conf) {
        return conf.getBoolean(GRIDFS_READ_BINARY, false);
    }

    public static void setGridFSReadBinary(Configuration conf, boolean readBinary) {
        conf.setBoolean(GRIDFS_READ_BINARY, readBinary);
    }

    public static void setNoTimeout(Configuration conf, boolean value) {
        conf.setBoolean(INPUT_NOTIMEOUT, value);
    }

    public static boolean isNoTimeout(Configuration conf) {
        return conf.getBoolean(INPUT_NOTIMEOUT, false);
    }

    public static boolean getBSONReadSplits(Configuration conf) {
        return conf.getBoolean(BSON_READ_SPLITS, true);
    }

    public static void setBSONReadSplits(Configuration conf, boolean val) {
        conf.setBoolean(BSON_READ_SPLITS, val);
    }

    public static boolean getBSONWriteSplits(Configuration conf) {
        return conf.getBoolean(BSON_WRITE_SPLITS, true);
    }

    public static void setBSONWriteSplits(Configuration conf, boolean val) {
        conf.setBoolean(BSON_WRITE_SPLITS, val);
    }

    public static boolean getBSONOutputBuildSplits(Configuration conf) {
        return conf.getBoolean(BSON_OUTPUT_BUILDSPLITS, false);
    }

    public static void setBSONOutputBuildSplits(Configuration conf, boolean val) {
        conf.setBoolean(BSON_OUTPUT_BUILDSPLITS, val);
    }

    public static void setBSONPathFilter(Configuration conf, Class<? extends PathFilter> val) {
        conf.setClass(BSON_PATHFILTER, val, PathFilter.class);
    }

    public static Class<?> getBSONPathFilter(Configuration conf) {
        return conf.getClass(BSON_PATHFILTER, null);
    }

    public static String getBSONSplitsPath(Configuration conf) {
        return conf.get(BSON_SPLITS_PATH);
    }

    public static void setBSONSplitsPath(Configuration conf, String path) {
        conf.set(BSON_SPLITS_PATH, path);
    }

    public static Class<? extends MongoSplitter> getSplitterClass(Configuration conf) {
        return conf.getClass(MONGO_SPLITTER_CLASS, null, MongoSplitter.class);
    }

    public static void setSplitterClass(Configuration conf, Class<? extends MongoSplitter> val) {
        conf.setClass(MONGO_SPLITTER_CLASS, val, MongoSplitter.class);
    }

    public static List<String> getInputMongosHosts(Configuration conf) {
        String raw = conf.get(INPUT_MONGOS_HOSTS, null);
        if (raw == null || raw.length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)raw));
    }

    public static void setInputMongosHosts(Configuration conf, List<String> hostnames) {
        String raw = "";
        if (hostnames != null) {
            raw = StringUtils.join(hostnames, (char)' ');
        }
        conf.set(INPUT_MONGOS_HOSTS, raw);
    }

    public static <U> Class<? extends U> getClassByName(Configuration conf, String className, Class<U> xface) {
        if (className == null) {
            return null;
        }
        try {
            Class theClass = conf.getClassByName(className);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Configuration buildConfiguration(Map<String, Object> data) {
        Configuration newConf = new Configuration();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                newConf.set(key, (String)val);
                continue;
            }
            if (val instanceof Boolean) {
                newConf.setBoolean(key, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof Integer) {
                newConf.setInt(key, ((Integer)val).intValue());
                continue;
            }
            if (val instanceof Float) {
                newConf.setFloat(key, ((Float)val).floatValue());
                continue;
            }
            if (val instanceof DBObject) {
                MongoConfigUtil.setDBObject(newConf, key, (DBObject)val);
                continue;
            }
            throw new RuntimeException("can't convert " + val.getClass() + " into any type for Configuration");
        }
        return newConf;
    }

    public static void close(Mongo client) {
        MongoClientURI uri = URI_MAP.get().remove(client);
        if (uri != null) {
            MongoClient remove = CLIENTS.get().remove(uri);
            if (remove != client) {
                throw new IllegalStateException("different clients found");
            }
            client.close();
        }
    }

    private static MongoClient getMongoClient(MongoClientURI uri) throws UnknownHostException {
        MongoClient mongoClient = CLIENTS.get().get(uri);
        if (mongoClient == null) {
            mongoClient = new MongoClient(uri);
            CLIENTS.get().put(uri, mongoClient);
            URI_MAP.get().put(mongoClient, uri);
        }
        return mongoClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFromFile(Configuration conf, String filename) throws IOException {
        Path propertiesFilePath = new Path(filename);
        FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)conf);
        if (!fs.exists(propertiesFilePath)) {
            throw new IOException("Properties file does not exist: " + filename);
        }
        FSDataInputStream inputStream = fs.open(propertiesFilePath);
        Properties properties = new Properties();
        try {
            properties.load((InputStream)inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties;
    }
}

