/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.hadoop.util.MapredMongoConfigUtil;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;

public class MongoTool
extends Configured
implements Tool {
    private static final Log LOG;
    private static final Boolean MAPRED_V1;
    private String jobName = ((Object)((Object)this)).getClass().getSimpleName();

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String name) {
        this.jobName = name;
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        LOG.info((Object)String.format("Created a conf: '%s' on {%s} as job named '%s'", conf, ((Object)((Object)this)).getClass(), this.getJobName()));
        if (LOG.isTraceEnabled()) {
            for (Map.Entry entry : conf) {
                LOG.trace((Object)String.format("%s=%s\n", entry.getKey(), entry.getValue()));
            }
        }
        if (MongoTool.isMapRedV1()) {
            return this.runMapredJob(conf);
        }
        return this.runMapReduceJob(conf);
    }

    public static boolean isMapRedV1() {
        return MAPRED_V1;
    }

    private int runMapredJob(Configuration conf) {
        JobConf job = new JobConf(conf, ((Object)((Object)this)).getClass());
        job.setJarByClass(((Object)((Object)this)).getClass());
        Class<? extends org.apache.hadoop.mapred.Mapper> mapper = MapredMongoConfigUtil.getMapper(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapper Class: " + mapper));
            LOG.debug((Object)("Input URI: " + conf.get("mongo.input.uri")));
        }
        job.setMapperClass(mapper);
        Class<? extends org.apache.hadoop.mapred.Reducer> combiner = MapredMongoConfigUtil.getCombiner(conf);
        if (combiner != null) {
            job.setCombinerClass(combiner);
        }
        job.setReducerClass(MapredMongoConfigUtil.getReducer(conf));
        job.setOutputFormat(MapredMongoConfigUtil.getOutputFormat(conf));
        job.setOutputKeyClass(MapredMongoConfigUtil.getOutputKey(conf));
        job.setOutputValueClass(MapredMongoConfigUtil.getOutputValue(conf));
        job.setInputFormat(MapredMongoConfigUtil.getInputFormat(conf));
        Class<?> mapOutputKeyClass = MapredMongoConfigUtil.getMapperOutputKey(conf);
        Class<?> mapOutputValueClass = MapredMongoConfigUtil.getMapperOutputValue(conf);
        if (mapOutputKeyClass != null) {
            job.setMapOutputKeyClass(mapOutputKeyClass);
        }
        if (mapOutputValueClass != null) {
            job.setMapOutputValueClass(mapOutputValueClass);
        }
        boolean verbose = MapredMongoConfigUtil.isJobVerbose(conf);
        boolean background = MapredMongoConfigUtil.isJobBackground(conf);
        try {
            RunningJob runningJob = JobClient.runJob((JobConf)job);
            if (background) {
                LOG.info((Object)"Setting up and running MapReduce job in background.");
                return 0;
            }
            LOG.info((Object)("Setting up and running MapReduce job in foreground, will wait for results.  {Verbose? " + verbose + "}"));
            runningJob.waitForCompletion();
            return 0;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while executing job... ", (Throwable)e);
            return 1;
        }
    }

    private int runMapReduceJob(Configuration conf) throws IOException {
        Job job = Job.getInstance((Configuration)conf, (String)this.getJobName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        Class<? extends Mapper> mapper = MongoConfigUtil.getMapper(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapper Class: " + mapper));
            LOG.debug((Object)("Input URI: " + conf.get("mongo.input.uri")));
        }
        job.setMapperClass(mapper);
        Class<? extends Reducer> combiner = MongoConfigUtil.getCombiner(conf);
        if (combiner != null) {
            job.setCombinerClass(combiner);
        }
        job.setReducerClass(MongoConfigUtil.getReducer(conf));
        job.setOutputFormatClass(MongoConfigUtil.getOutputFormat(conf));
        job.setOutputKeyClass(MongoConfigUtil.getOutputKey(conf));
        job.setOutputValueClass(MongoConfigUtil.getOutputValue(conf));
        job.setInputFormatClass(MongoConfigUtil.getInputFormat(conf));
        Class<?> mapOutputKeyClass = MongoConfigUtil.getMapperOutputKey(conf);
        Class<?> mapOutputValueClass = MongoConfigUtil.getMapperOutputValue(conf);
        if (mapOutputKeyClass != null) {
            job.setMapOutputKeyClass(mapOutputKeyClass);
        }
        if (mapOutputValueClass != null) {
            job.setMapOutputValueClass(mapOutputValueClass);
        }
        boolean verbose = MongoConfigUtil.isJobVerbose(conf);
        boolean background = MongoConfigUtil.isJobBackground(conf);
        try {
            if (background) {
                LOG.info((Object)"Setting up and running MapReduce job in background.");
                job.submit();
                return 0;
            }
            LOG.info((Object)("Setting up and running MapReduce job in foreground, will wait for results.  {Verbose? " + verbose + "}"));
            return job.waitForCompletion(true) ? 0 : 1;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while executing job... ", (Throwable)e);
            return 1;
        }
    }

    static {
        boolean mapred;
        LOG = LogFactory.getLog(MongoTool.class);
        try {
            FileSystem.class.getDeclaredField("DEFAULT_FS");
            mapred = false;
        }
        catch (NoSuchFieldException e) {
            mapred = true;
        }
        MAPRED_V1 = mapred;
    }
}

