/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.DBRef;
import com.mongodb.spark.pickle.BSONValueBox;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.razorvine.pickle.IObjectPickler;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.Pickler;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.CodeWithScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class BSONPickler
implements IObjectPickler {
    private void putBinstring(byte[] bytes, OutputStream out) throws IOException {
        int binLen = bytes.length;
        if (binLen <= 255) {
            out.write(85);
            out.write(binLen);
        } else {
            out.write(84);
            out.write(binLen & 0xFF);
            out.write(binLen >>> 8 & 0xFF);
            out.write(binLen >>> 16 & 0xFF);
            out.write(binLen >>> 24 & 0xFF);
        }
        out.write(bytes);
    }

    private void putBinstring(String string, OutputStream out) throws IOException {
        this.putBinstring(string.getBytes(), out);
    }

    private int translateRegexFlags(int javaFlags) {
        int pyFlags = 0;
        if ((javaFlags & 2) > 0) {
            pyFlags |= 2;
        }
        if ((javaFlags & 4) > 0) {
            pyFlags |= 0x40;
        }
        if ((javaFlags & 0x20) > 0) {
            pyFlags |= 0x10;
        }
        if ((javaFlags & 8) > 0) {
            pyFlags |= 8;
        }
        if ((javaFlags & 0x40 | javaFlags & 0x100) > 0) {
            pyFlags |= 0x20;
        }
        return pyFlags;
    }

    private void pickleRegex(Pattern pattern, OutputStream out, Pickler pickler) throws IOException {
        out.write(99);
        out.write("bson.regex\nRegex\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(125);
        out.write(40);
        this.putBinstring("pattern", out);
        pickler.save((Object)pattern.pattern());
        this.putBinstring("flags", out);
        pickler.save((Object)this.translateRegexFlags(pattern.flags()));
        out.write(117);
        out.write(98);
    }

    private void pickleBSONTimestamp(BSONTimestamp timestamp, OutputStream out, Pickler pickler) throws IOException {
        out.write(99);
        out.write("bson.timestamp\nTimestamp\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(125);
        out.write(40);
        this.putBinstring("_Timestamp__time", out);
        pickler.save((Object)timestamp.getTime());
        this.putBinstring("_Timestamp__inc", out);
        pickler.save((Object)timestamp.getInc());
        out.write(117);
        out.write(98);
    }

    private void pickleCode(Code code, OutputStream out, Pickler pickler) throws IOException {
        out.write(99);
        out.write("bson.code\nCode\n".getBytes());
        pickler.save((Object)code.getCode());
        out.write(133);
        out.write(129);
        out.write(125);
        this.putBinstring("_Code__scope", out);
        if (code instanceof CodeWithScope) {
            pickler.save((Object)((CodeWithScope)code).getScope());
        } else if (code instanceof CodeWScope) {
            pickler.save((Object)((CodeWScope)code).getScope().toMap());
        } else {
            out.write(125);
        }
        out.write(115);
        out.write(98);
    }

    private void writeMinKey(OutputStream out) throws IOException {
        out.write(99);
        out.write("bson.min_key\nMinKey\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(125);
        out.write(98);
    }

    private void writeMaxKey(OutputStream out) throws IOException {
        out.write(99);
        out.write("bson.max_key\nMaxKey\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(125);
        out.write(98);
    }

    private void pickleDBRef(DBRef dbref, OutputStream out, Pickler pickler) throws IOException {
        out.write(99);
        out.write("bson.dbref\nDBRef\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(125);
        out.write(40);
        this.putBinstring("_DBRef__kwargs", out);
        out.write(125);
        this.putBinstring("_DBRef__collection", out);
        pickler.save((Object)dbref.getCollectionName());
        this.putBinstring("_DBRef__database", out);
        out.write(78);
        this.putBinstring("_DBRef__id", out);
        pickler.save(dbref.getId());
        out.write(117);
        out.write(98);
    }

    private void pickleBinary(Binary binary, OutputStream out, Pickler pickler) throws IOException {
        out.write(99);
        out.write("bson.binary\nBinary\n".getBytes());
        this.putBinstring(binary.getData(), out);
        pickler.save((Object)binary.getType());
        out.write(134);
        out.write(129);
        out.write(125);
        this.putBinstring("_Binary__subtype", out);
        pickler.save((Object)binary.getType());
        out.write(115);
        out.write(98);
    }

    private void pickleObjectId(ObjectId oid, OutputStream out) throws IOException {
        out.write(99);
        out.write("bson.objectid\nObjectId\n".getBytes());
        out.write(41);
        out.write(129);
        out.write(85);
        out.write(12);
        out.write(oid.toByteArray());
        out.write(98);
    }

    private void pickleDate(Date date, OutputStream out, Pickler currentPickler) throws IOException {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        out.write(99);
        out.write("datetime\ndatetime\n".getBytes());
        out.write(40);
        currentPickler.save((Object)calendar.get(1));
        currentPickler.save((Object)(calendar.get(2) + 1));
        currentPickler.save((Object)calendar.get(5));
        currentPickler.save((Object)calendar.get(11));
        currentPickler.save((Object)calendar.get(12));
        currentPickler.save((Object)calendar.get(13));
        currentPickler.save((Object)(calendar.get(14) * 1000));
        out.write(116);
        out.write(82);
    }

    public void pickle(Object obj, OutputStream out, Pickler currentPickler) throws IOException {
        Object o = obj;
        if (obj instanceof BSONValueBox) {
            o = ((BSONValueBox)obj).get();
        }
        if (o instanceof ObjectId) {
            this.pickleObjectId((ObjectId)o, out);
        } else if (o instanceof Binary) {
            this.pickleBinary((Binary)o, out, currentPickler);
        } else if (o instanceof DBRef) {
            this.pickleDBRef((DBRef)o, out, currentPickler);
        } else if (o instanceof MaxKey) {
            this.writeMaxKey(out);
        } else if (o instanceof MinKey) {
            this.writeMinKey(out);
        } else if (o instanceof Code) {
            this.pickleCode((Code)o, out, currentPickler);
        } else if (o instanceof BSONTimestamp) {
            this.pickleBSONTimestamp((BSONTimestamp)o, out, currentPickler);
        } else if (o instanceof Pattern) {
            this.pickleRegex((Pattern)o, out, currentPickler);
        } else if (o instanceof Date) {
            this.pickleDate((Date)o, out, currentPickler);
        } else {
            throw new PickleException("Can't pickle this: " + o);
        }
    }
}

