/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.hadoop.io.BSONWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;
import org.bson.BasicBSONObject;
import org.bson.Transformer;

abstract class BSONValueBox<T>
implements Writable,
Serializable {
    private static final Transformer TRANSFORMER = new Transformer(){

        @Override
        public Object transform(Object objectToTransform) {
            if (!(objectToTransform instanceof BSONValueBox)) {
                throw new IllegalArgumentException("Can only transform instances of BSONValueBox, not " + objectToTransform);
            }
            return ((BSONValueBox)objectToTransform).get();
        }
    };

    BSONValueBox() {
    }

    public abstract T get();

    static Transformer getTransformer() {
        return TRANSFORMER;
    }

    public void readFields(DataInput in) throws IOException {
        throw new IOException("Cannot read fields into a BSONValueBox.");
    }

    public void write(DataOutput out) throws IOException {
        new BSONWritable(new BasicBSONObject("value", this.get())).write(out);
    }
}

