/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.spark.pickle.BSONValueBox;
import java.util.HashMap;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import org.bson.BSON;
import org.bson.types.Binary;

public class BinaryConstructor
implements IObjectConstructor {
    public Object construct(Object[] args) {
        if (args.length != 2) {
            throw new PickleException("Binary constructor requires 2 arguments, not " + args.length);
        }
        if (!(args[0] instanceof String) || !(args[1] instanceof Integer)) {
            throw new PickleException("Binary constructor takes a String and an Integer, not a " + args[0].getClass().getName() + " and a " + args[1].getClass().getName());
        }
        return new BinaryBox((String)args[0], (Integer)args[1]);
    }

    public static class BinaryBox
    extends BSONValueBox<Binary> {
        private Binary value = null;

        public BinaryBox(String data, int type) {
            byte[] byteData = new byte[data.length()];
            for (int i = 0; i < byteData.length; ++i) {
                byteData[i] = (byte)data.charAt(i);
            }
            this.value = new Binary((byte)type, byteData);
        }

        public void __setstate__(HashMap<String, Object> hm) {
        }

        @Override
        public Binary get() {
            return this.value;
        }

        static {
            BSON.addEncodingHook(BinaryBox.class, BinaryBox.getTransformer());
        }
    }
}

