/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.spark.pickle.BSONValueBox;
import java.util.HashMap;
import java.util.Map;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import org.bson.BSON;
import org.bson.BasicBSONObject;
import org.bson.types.Code;
import org.bson.types.CodeWScope;

public class CodeConstructor
implements IObjectConstructor {
    public Object construct(Object[] args) {
        if (args.length != 1) {
            throw new PickleException("Code constructor requires 1 argument, not " + args.length);
        }
        if (!(args[0] instanceof String)) {
            throw new PickleException("Code constructor requries a String, not a " + args[0].getClass().getName());
        }
        return new CodeBox((String)args[0]);
    }

    public static class CodeBox
    extends BSONValueBox<Code> {
        private String code;
        private Code value;

        public CodeBox(String code) {
            this.code = code;
        }

        public void __setstate__(HashMap<String, Object> state) {
            Object scope = state.get("_Code__scope");
            if (!(scope instanceof Map)) {
                throw new PickleException("Expected a Map for key \"_Code__scope\", not a " + scope.getClass().getName());
            }
            Map scopeMap = (Map)scope;
            this.value = !scopeMap.isEmpty() ? new CodeWScope(this.code, new BasicBSONObject(scopeMap)) : new Code(this.code);
        }

        @Override
        public Code get() {
            return this.value;
        }

        static {
            BSON.addEncodingHook(CodeBox.class, CodeBox.getTransformer());
        }
    }
}

