/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.spark.pickle.BSONValueBox;
import java.util.HashMap;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import org.bson.BSON;

public class Int64Constructor
implements IObjectConstructor {
    public Object construct(Object[] args) {
        if (args.length != 1) {
            throw new PickleException("Int64 constructor requires 1 argument, not " + args.length);
        }
        if (!(args[0] instanceof Integer) && !(args[0] instanceof Long)) {
            throw new PickleException("Int64 constructor requires an Integer or Long, not a " + args[0].getClass().getName());
        }
        return new Int64Box((Long)args[0]);
    }

    public static class Int64Box
    extends BSONValueBox<Long> {
        private Long value;

        public Int64Box(Long value) {
            this.value = value;
        }

        public void __setstate__(HashMap<String, Object> state) {
        }

        @Override
        public Long get() {
            return this.value;
        }

        static {
            BSON.addEncodingHook(Int64Box.class, Int64Box.getTransformer());
        }
    }
}

