/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.spark.pickle.BSONValueBox;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import org.bson.BSON;

public class RegexConstructor
implements IObjectConstructor {
    public Object construct(Object[] args) {
        if (args.length != 0) {
            throw new PickleException("Regex constructor requires 0 arguments, not " + args.length);
        }
        return new RegexBox();
    }

    public static class RegexBox
    extends BSONValueBox<Pattern> {
        private Pattern value;

        private static int pythonFlagsToJavaFlags(int pythonFlags) {
            int javaFlags = 0;
            if ((pythonFlags & 2) > 0) {
                javaFlags |= 2;
            }
            if ((pythonFlags & 0x40) > 0) {
                javaFlags |= 4;
            }
            if ((pythonFlags & 0x10) > 0) {
                javaFlags |= 0x20;
            }
            if ((pythonFlags & 8) > 0) {
                javaFlags |= 8;
            }
            if ((pythonFlags & 0x20) > 0) {
                javaFlags |= 0x140;
            }
            return javaFlags;
        }

        public void __setstate__(HashMap<String, Object> state) {
            Object pattern = state.get("pattern");
            Object flags = state.get("flags");
            if (!(pattern instanceof String) || !(flags instanceof Integer)) {
                throw new PickleException("Expected a String for key \"pattern\" and an Integer for key \"flags\", not a " + pattern.getClass().getName() + " and a " + flags.getClass().getName());
            }
            this.value = Pattern.compile((String)pattern, RegexBox.pythonFlagsToJavaFlags((Integer)flags));
        }

        @Override
        public Pattern get() {
            return this.value;
        }

        static {
            BSON.addEncodingHook(RegexBox.class, RegexBox.getTransformer());
        }
    }
}

