/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.pickle;

import com.mongodb.spark.pickle.BSONValueBox;
import java.util.HashMap;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import org.bson.BSON;
import org.bson.types.BSONTimestamp;

public class TimestampConstructor
implements IObjectConstructor {
    public Object construct(Object[] args) {
        if (args.length != 0) {
            throw new PickleException("Timestamp constructor requires 0 arguments, not " + args.length);
        }
        return new TimestampBox();
    }

    public static class TimestampBox
    extends BSONValueBox<BSONTimestamp> {
        private BSONTimestamp value;

        public void __setstate__(HashMap state) {
            Object time = state.get("_Timestamp__time");
            Object inc = state.get("_Timestamp__inc");
            if (!(time instanceof Integer) || !(inc instanceof Integer)) {
                throw new PickleException("Excpected Integer for keys \"_Timestamp__time\" and \"Timestamp__inc\", not a " + time.getClass().getName() + " and a " + inc.getClass().getName());
            }
            this.value = new BSONTimestamp((Integer)time, (Integer)inc);
        }

        @Override
        public BSONTimestamp get() {
            return this.value;
        }

        static {
            BSON.addEncodingHook(TimestampBox.class, TimestampBox.getTransformer());
        }
    }
}

