/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResourcesResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArtifactUrlClassification resolveServiceResourcesFor(ArtifactUrlClassification serviceUrlClassification) {
        HashSet exportPackages = Sets.newHashSet();
        HashSet exportResources = Sets.newHashSet();
        HashSet privilegedExportedPackages = Sets.newHashSet();
        HashSet privilegedArtifacts = Sets.newHashSet();
        try (URLClassLoader classLoader = new URLClassLoader(serviceUrlClassification.getUrls().toArray(new URL[0]), null);){
            MuleServiceModel muleServiceModel;
            Object object;
            this.logger.debug("Loading service '{}' descriptor", (Object)serviceUrlClassification.getName());
            URL artifactJsonUrl = classLoader.findResource("META-INF/mule-artifact.json");
            if (artifactJsonUrl == null && (artifactJsonUrl = classLoader.getResource("META-INF/mule-artifact/mule-artifact.json")) == null) {
                throw new IllegalStateException("mule-artifact.json couldn't be found for service: " + serviceUrlClassification.getName());
            }
            try {
                InputStream stream = artifactJsonUrl.openStream();
                object = null;
                try {
                    muleServiceModel = (MuleServiceModel)new MuleServiceModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read extension describer on service '%s'", artifactJsonUrl), e);
            }
            MuleArtifactLoaderDescriptor classLoaderModelDescriptor = muleServiceModel.getClassLoaderModelLoaderDescriptor();
            exportPackages.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("exportedPackages", new ArrayList()));
            exportResources.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("exportedResources", new ArrayList()));
            privilegedExportedPackages.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("privilegedExportedPackages", new ArrayList()));
            privilegedArtifacts.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("privilegedArtifactIds", new ArrayList()));
            object = new ArtifactUrlClassification(serviceUrlClassification.getArtifactId(), muleServiceModel.getServiceProviderClassName(), serviceUrlClassification.getUrls());
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

