/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.neo4j.driver.Config;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlanImpl;

public class SecuritySettings {
    private static final boolean DEFAULT_ENCRYPTED = false;
    private static final Config.TrustStrategy DEFAULT_TRUST_STRATEGY = Config.TrustStrategy.trustSystemCertificates();
    private static final SecuritySettings DEFAULT = new SecuritySettings(false, DEFAULT_TRUST_STRATEGY);
    private final boolean encrypted;
    private final Config.TrustStrategy trustStrategy;

    public SecuritySettings(boolean encrypted, Config.TrustStrategy trustStrategy) {
        this.encrypted = encrypted;
        this.trustStrategy = trustStrategy == null ? DEFAULT_TRUST_STRATEGY : trustStrategy;
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public Config.TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    private boolean isCustomized() {
        return this != DEFAULT;
    }

    public SecurityPlan createSecurityPlan(String uriScheme) {
        try {
            if (Scheme.isSecurityScheme(uriScheme)) {
                this.assertSecuritySettingsNotUserConfigured(uriScheme);
                return this.createSecurityPlanFromScheme(uriScheme);
            }
            return SecuritySettings.createSecurityPlanImpl(this.encrypted, this.trustStrategy);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
    }

    private void assertSecuritySettingsNotUserConfigured(String uriScheme) {
        if (this.isCustomized()) {
            throw new ClientException(String.format("Scheme %s is not configurable with manual encryption and trust settings", uriScheme));
        }
    }

    private SecurityPlan createSecurityPlanFromScheme(String scheme) throws GeneralSecurityException, IOException {
        if (Scheme.isHighTrustScheme(scheme)) {
            return SecurityPlanImpl.forSystemCASignedCertificates(this.trustStrategy.isHostnameVerificationEnabled());
        }
        return SecurityPlanImpl.forAllCertificates(this.trustStrategy.isHostnameVerificationEnabled());
    }

    private static SecurityPlan createSecurityPlanImpl(boolean encrypted, Config.TrustStrategy trustStrategy) throws GeneralSecurityException, IOException {
        if (encrypted) {
            boolean hostnameVerificationEnabled = trustStrategy.isHostnameVerificationEnabled();
            switch (trustStrategy.strategy()) {
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlanImpl.forCustomCASignedCertificates(trustStrategy.certFile(), hostnameVerificationEnabled);
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlanImpl.forSystemCASignedCertificates(hostnameVerificationEnabled);
                }
                case TRUST_ALL_CERTIFICATES: {
                    return SecurityPlanImpl.forAllCertificates(hostnameVerificationEnabled);
                }
            }
            throw new ClientException("Unknown TLS authentication strategy: " + trustStrategy.strategy().name());
        }
        return SecurityPlanImpl.insecure();
    }

    public static class SecuritySettingsBuilder {
        private boolean isCustomized = false;
        private boolean encrypted;
        private Config.TrustStrategy trustStrategy;

        public SecuritySettingsBuilder withEncryption() {
            this.encrypted = true;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettingsBuilder withoutEncryption() {
            this.encrypted = false;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettingsBuilder withTrustStrategy(Config.TrustStrategy strategy) {
            this.trustStrategy = strategy;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettings build() {
            return this.isCustomized ? new SecuritySettings(this.encrypted, this.trustStrategy) : DEFAULT;
        }
    }
}

