/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.MessageWithMetadata;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class TransactionMetadataBuilder {
    private static final String BOOKMARKS_METADATA_KEY = "bookmarks";
    private static final String DATABASE_NAME_KEY = "db";
    private static final String TX_TIMEOUT_METADATA_KEY = "tx_timeout";
    private static final String TX_METADATA_METADATA_KEY = "tx_metadata";
    private static final String MODE_KEY = "mode";
    private static final String MODE_READ_VALUE = "r";
    private static final String IMPERSONATED_USER_KEY = "imp_user";
    private static final String TX_TYPE_KEY = "tx_type";

    public static Map<String, Value> buildMetadata(Duration txTimeout, Map<String, Value> txMetadata, DatabaseName databaseName, AccessMode mode, Set<String> bookmarks, String impersonatedUser, String txType, NotificationConfig notificationConfig, boolean legacyNotifications, LoggingProvider logging, ValueFactory valueFactory) {
        boolean notificationConfigPresent;
        boolean bookmarksPresent = !bookmarks.isEmpty();
        boolean txTimeoutPresent = txTimeout != null;
        boolean txMetadataPresent = txMetadata != null && !txMetadata.isEmpty();
        boolean accessModePresent = mode == AccessMode.READ;
        boolean databaseNamePresent = databaseName.databaseName().isPresent();
        boolean impersonatedUserPresent = impersonatedUser != null;
        boolean txTypePresent = txType != null;
        boolean bl = notificationConfigPresent = notificationConfig != null;
        if (!(bookmarksPresent || txTimeoutPresent || txMetadataPresent || accessModePresent || databaseNamePresent || impersonatedUserPresent || txTypePresent || notificationConfigPresent)) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> result = new HashMap<String, Value>(5);
        if (bookmarksPresent) {
            result.put(BOOKMARKS_METADATA_KEY, valueFactory.value(bookmarks));
        }
        if (txTimeoutPresent) {
            long millis = txTimeout.toMillis();
            if (txTimeout.toNanosPart() % 1000000 > 0) {
                System.Logger log = logging.getLog(TransactionMetadataBuilder.class);
                ++millis;
                log.log(System.Logger.Level.INFO, "The transaction timeout has been rounded up to next millisecond value since the config had a fractional millisecond value");
            }
            result.put(TX_TIMEOUT_METADATA_KEY, valueFactory.value(millis));
        }
        if (txMetadataPresent) {
            result.put(TX_METADATA_METADATA_KEY, valueFactory.value(txMetadata));
        }
        if (accessModePresent) {
            result.put(MODE_KEY, valueFactory.value(MODE_READ_VALUE));
        }
        if (impersonatedUserPresent) {
            result.put(IMPERSONATED_USER_KEY, valueFactory.value(impersonatedUser));
        }
        if (txTypePresent) {
            result.put(TX_TYPE_KEY, valueFactory.value(txType));
        }
        MessageWithMetadata.appendNotificationConfig(result, notificationConfig, legacyNotifications, valueFactory);
        databaseName.databaseName().ifPresent(name -> result.put(DATABASE_NAME_KEY, valueFactory.value((String)name)));
        return result;
    }
}

