/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v6;

import java.io.IOException;
import java.lang.reflect.Array;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.common.CommonValuePacker;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.packstream.PackOutput;
import org.neo4j.jdbc.internal.shaded.bolt.values.Vector;

final class ValuePackerV6
extends CommonValuePacker {
    public ValuePackerV6(PackOutput output) {
        super(output, true);
    }

    @Override
    protected void packVector(Vector vector) throws IOException {
        RawPacker rawPacker;
        int sizeMultiplier;
        byte elementyTypeAsByte;
        Class<Long> elementType = vector.elementType();
        Object elements = vector.elements();
        int length = Array.getLength(elements);
        if (elementType.equals(Long.TYPE) || elementType.isAssignableFrom(Long.class)) {
            elementyTypeAsByte = -53;
            sizeMultiplier = 8;
            rawPacker = i -> this.packer.packRaw(Array.getLong(elements, i));
        } else if (elementType.equals(Integer.TYPE) || elementType.equals(Integer.class)) {
            elementyTypeAsByte = -54;
            sizeMultiplier = 4;
            rawPacker = i -> this.packer.packRaw(Array.getInt(elements, i));
        } else if (elementType.equals(Double.TYPE) || elementType.equals(Double.class)) {
            elementyTypeAsByte = -63;
            sizeMultiplier = 8;
            rawPacker = i -> this.packer.packRaw(Array.getDouble(elements, i));
        } else if (elementType.equals(Float.TYPE) || elementType.equals(Float.class)) {
            elementyTypeAsByte = -58;
            sizeMultiplier = 4;
            rawPacker = i -> this.packer.packRaw(Array.getFloat(elements, i));
        } else if (elementType.equals(Short.TYPE) || elementType.equals(Short.class)) {
            elementyTypeAsByte = -55;
            sizeMultiplier = 2;
            rawPacker = i -> this.packer.packRaw(Array.getShort(elements, i));
        } else if (elementType.equals(Byte.TYPE) || elementType.equals(Byte.class)) {
            elementyTypeAsByte = -56;
            sizeMultiplier = 1;
            rawPacker = i -> this.packer.packRaw(Array.getByte(elements, i));
        } else {
            throw new IOException("Unsupported vector element type: " + String.valueOf(elementType));
        }
        this.packStructHeader(2, (byte)86);
        this.packer.pack(new byte[]{elementyTypeAsByte});
        this.packer.packBytesHeader(length * sizeMultiplier);
        for (int i2 = 0; i2 < length; ++i2) {
            rawPacker.packRaw(i2);
        }
    }

    private static interface RawPacker {
        public void packRaw(int var1) throws IOException;
    }
}

