/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.message.PullMessage;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ImmutableObservation;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.PullSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.Query;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;

final class PullMessageHandler
implements MessageHandler<Void> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final PullMessage message;
    private final Function<Long, Query> queryFinder;
    private final Consumer<Long> queryDeleteConsumer;

    PullMessageHandler(ResponseHandler handler, PullMessage message, Function<Long, Query> queryFinder, Consumer<Long> queryDeleteConsumer, LoggingProvider logging) {
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.message = Objects.requireNonNull(message);
        this.queryFinder = Objects.requireNonNull(queryFinder);
        this.queryDeleteConsumer = Objects.requireNonNull(queryDeleteConsumer);
    }

    @Override
    public CompletionStage<Void> exchange(ImmutableObservation parentObservation) {
        return CompletableFuture.completedStage(null).thenApply(ignored -> {
            Query query = this.queryFinder.apply(this.message.qid());
            ArrayList<List> records = new ArrayList<List>();
            boolean deleted = false;
            Iterator<List<Value>> iterator = query.values().iterator();
            for (long request = this.message.request() > 0L ? this.message.request() : Long.MAX_VALUE; iterator.hasNext() && request > 0L; --request) {
                records.add(iterator.next());
                iterator.remove();
            }
            if (query.values().isEmpty()) {
                this.queryDeleteConsumer.accept(query.id());
                deleted = true;
            }
            this.queryDeleteConsumer.accept(-1L);
            records.forEach(this.handler::onRecord);
            boolean hasMore = !deleted;
            this.handler.onPullSummary(new PullSummaryImpl(hasMore, hasMore ? Map.of() : query.metadata()));
            return null;
        });
    }
}

