/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@Neo4jVersion(minimum="5.9")
@API(status=API.Status.STABLE, since="2023.9.0")
public final class QuantifiedPathPattern
implements PatternElement {
    private final TargetPattern delegate;
    private final Quantifier quantifier;

    private QuantifiedPathPattern(TargetPattern delegate, Quantifier quantifier) {
        this.delegate = delegate;
        this.quantifier = quantifier;
    }

    public static Quantifier interval(Integer lowerBound, Integer upperBound) {
        return new IntervalQuantifier(lowerBound, upperBound);
    }

    public static Quantifier plus() {
        return PlusQuantifier.INSTANCE;
    }

    public static Quantifier star() {
        return StarQuantifier.INSTANCE;
    }

    static QuantifiedPathPattern of(PatternElement patternElement, Quantifier quantifier) {
        TargetPattern ppp;
        TargetPattern delegate = patternElement instanceof TargetPattern ? (ppp = (TargetPattern)patternElement) : new TargetPattern(patternElement, null);
        return new QuantifiedPathPattern(delegate, quantifier);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.delegate.accept(visitor);
        Visitable.visitIfNotNull(this.quantifier, visitor);
        visitor.leave(this);
    }

    @Override
    public PatternElement where(Expression predicate) {
        if (predicate == null) {
            return this;
        }
        return QuantifiedPathPattern.of(this.delegate.where(predicate), this.quantifier);
    }

    @API(status=API.Status.INTERNAL)
    public static final class TargetPattern
    implements PatternElement {
        private final PatternElement delegate;
        private final Where innerPredicate;

        private TargetPattern(PatternElement delegate, Where innerPredicate) {
            this.delegate = delegate;
            this.innerPredicate = innerPredicate;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.delegate.accept(visitor);
            Visitable.visitIfNotNull(this.innerPredicate, visitor);
            visitor.leave(this);
        }

        @Override
        public PatternElement where(Expression predicate) {
            if (predicate == null) {
                return this;
            }
            return new TargetPattern(this.delegate, Where.from(predicate));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Quantifier
    extends Visitable {
    }

    private record IntervalQuantifier(Integer lowerBound, Integer upperBound) implements Quantifier
    {
        public IntervalQuantifier {
            if (lowerBound != null && lowerBound < 0) {
                throw new IllegalArgumentException("Lower bound must be greater than or equal to zero");
            }
            if (upperBound != null && upperBound <= 0) {
                throw new IllegalArgumentException("Upper bound must be greater than zero");
            }
            if (lowerBound != null && upperBound != null && upperBound < lowerBound) {
                throw new IllegalArgumentException("Upper bound must be greater than or equal to " + lowerBound);
            }
        }

        @Override
        public String toString() {
            Object result = "{";
            result = (String)result + String.valueOf(this.lowerBound() == null ? "0" : this.lowerBound());
            result = (String)result + ",";
            if (this.upperBound() != null) {
                result = (String)result + this.upperBound();
            }
            result = (String)result + "}";
            return result;
        }
    }

    private static enum PlusQuantifier implements Quantifier
    {
        INSTANCE;


        @Override
        public String toString() {
            return "+";
        }
    }

    private static enum StarQuantifier implements Quantifier
    {
        INSTANCE;


        @Override
        public String toString() {
            return "*";
        }
    }
}

