/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

abstract class AbstractFunction<T>
extends AbstractField<T>
implements QOM.Function<T> {
    private final boolean applySchemaMapping;

    AbstractFunction(Name name, DataType<T> type, boolean applySchemaMapping) {
        super(name, type);
        this.applySchemaMapping = applySchemaMapping;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        AbstractFunction.acceptFunctionName(ctx, this.applySchemaMapping, this.getQualifiedName());
        ctx.sql('(').visit(this.arguments()).sql(')');
    }

    static void acceptFunctionName(Context<?> ctx, boolean applySchemaMapping, Name name) {
        if (applySchemaMapping && name.qualified()) {
            Schema mapped = Tools.getMappedSchema(ctx, DSL.schema(name.qualifier()));
            if (mapped != null) {
                ctx.visit(mapped.getQualifiedName().append(name.unqualifiedName()));
            } else {
                ctx.visit(name.unqualifiedName());
            }
        } else {
            ctx.visit(name);
        }
    }

    abstract QueryPart arguments();
}

