/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.neo4j.jdbc.internal.shaded.jooq.BindContext;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.ExecuteContext;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractBindContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultBindingSetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SimpleExecuteContext;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.R2dbcException;

final class DefaultBindContext
extends AbstractBindContext {
    DefaultBindContext(Configuration configuration, ExecuteContext ctx, PreparedStatement stmt) {
        super(configuration, ctx, stmt);
    }

    @Override
    protected final BindContext bindValue0(Object value, Field<?> field) throws SQLException {
        int nextIndex = this.nextIndex();
        try {
            field.getBinding().set(new DefaultBindingSetStatementContext<Object>(this.executeContext() != null ? this.executeContext() : new SimpleExecuteContext(this.configuration(), this.data()), this.stmt, nextIndex, value));
        }
        catch (SQLException e) {
            throw new SQLException("Error while writing value at JDBC bind index: " + nextIndex, e.getSQLState(), e.getErrorCode(), e);
        }
        catch (R2dbcException e) {
            throw new SQLException("Error while writing value at R2DBC bind index: " + (nextIndex - 1), e.getSqlState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            throw new SQLException("Error while writing value at bind index: " + nextIndex, e);
        }
        return this;
    }
}

