/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.JSONB;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class JSONBKeys
extends AbstractField<JSONB>
implements QOM.JSONBKeys {
    static final Set<SQLDialect> NO_SUPPORT_PATH_QUERY = SQLDialect.supportedUntil(new SQLDialect[0]);
    final Field<JSONB> field;

    JSONBKeys(Field<JSONB> field) {
        super(Names.N_JSONB_KEYS, Tools.allNotNull(SQLDataType.JSONB, field));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.JSONB);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
            case SQLITE: {
                return false;
            }
            case TRINO: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (NO_SUPPORT_PATH_QUERY.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.field(DSL.select(DSL.coalesce(DSL.jsonArrayAgg(DSL.field(DSL.unquotedName("j"))), new Field[]{DSL.jsonArray(new Field[0])})).from("json_object_keys({0}) as j(j)", this.field)));
                    break;
                }
                ctx.visit(DSL.function(Names.N_JSONB_PATH_QUERY_ARRAY, this.getDataType(), this.field, DSL.inline("$.keyvalue().key")));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.field(DSL.select(DSL.jsonbArrayAgg(DSL.field(DSL.name("key")))).from("json_each({0})", this.field)));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.cast(DSL.function(Names.N_MAP_KEYS, SQLDataType.OTHER, DSL.field("cast({0} as map(varchar, json))", SQLDataType.OTHER, new QueryPart[]{this.field})), SQLDataType.JSON));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_JSON_KEYS, SQLDataType.JSONB, this.field));
            }
        }
    }

    @Override
    public final Field<JSONB> $arg1() {
        return this.field;
    }

    @Override
    public final QOM.JSONBKeys $arg1(Field<JSONB> newValue) {
        return this.$constructor().apply((Field<JSONB>)newValue);
    }

    @Override
    public final Function1<? super Field<JSONB>, ? extends QOM.JSONBKeys> $constructor() {
        return a1 -> new JSONBKeys((Field<JSONB>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONBKeys) {
            QOM.JSONBKeys o = (QOM.JSONBKeys)that;
            return StringUtils.equals(this.$field(), o.$field());
        }
        return super.equals(that);
    }
}

