/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.List;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.SelectField;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AliasedSelect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SelectIsNull;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class SelectIsNotNull
extends AbstractCondition
implements QOM.SelectIsNotNull {
    private final Select<?> select;

    SelectIsNotNull(Select<?> select) {
        this.select = select;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (SelectIsNull.EMULATE_NULL_QUERY.contains((Object)ctx.dialect())) {
            List<Field<?>> f = Tools.collect(Tools.flattenCollection(this.select.getSelect()));
            if (f.size() == 1) {
                this.acceptStandard(ctx);
            } else {
                Name[] n = Tools.fieldNames(f.size());
                SelectField t = new AliasedSelect(this.select, true, true, false, n).as("t");
                ctx.visit(DSL.inline(1).eq(DSL.selectCount().from((TableLike<?>)((Object)t)).where(Tools.allNotNull(Tools.fieldsByName(n)))));
            }
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final void acceptStandard(Context<?> ctx) {
        Tools.visitSubquery(ctx, this.select, 256);
        switch (ctx.family()) {
            default: 
        }
        ctx.sql(' ').visit(Keywords.K_IS_NOT_NULL);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Select<?> $arg1() {
        return this.select;
    }

    @Override
    public final Function1<? super Select<?>, ? extends QOM.SelectIsNotNull> $constructor() {
        return r -> new SelectIsNotNull((Select<?>)r);
    }
}

